/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.apps.AbstractPluginApp;
import org.genemania.plugin.data.DataDescriptor;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.xml.sax.SAXException;

public class DataAdmin
extends AbstractPluginApp {
    @Argument
    protected List<String> fArguments = new ArrayList<String>();

    protected List<String> getArguments() {
        return this.fArguments;
    }

    public static void main(String[] args) throws Exception {
        DataAdmin admin = new DataAdmin();
        CmdLineParser parser = new CmdLineParser((Object)admin);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            DataAdmin.printUsage(parser);
            return;
        }
        admin.initialize();
        try {
            admin.handleArguments();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message != null) {
                System.err.println(message);
            }
            DataAdmin.printUsage(parser);
        }
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println(String.format("\nGeneral usage: %s (list | install | list-data | install-data | uninstall-data) options\n", DataAdmin.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
    }

    private void handleArguments() throws InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        Logger.getLogger((String)"org.genemania.plugin").setLevel(Level.WARN);
        Logger.getLogger((String)"org.genemania").setLevel(Level.ERROR);
        HashMap<String, Class<UninstallDescriptorsCommand>> commands = new HashMap<String, Class<UninstallDescriptorsCommand>>();
        commands.put("list", ListDataSetCommand.class);
        commands.put("install", InstallDataSetCommand.class);
        commands.put("list-data", ListDescriptorsCommand.class);
        commands.put("install-data", InstallDescriptorsCommand.class);
        commands.put("uninstall-data", UninstallDescriptorsCommand.class);
        List<String> arguments = this.getArguments();
        if (arguments.size() == 0) {
            throw new IllegalArgumentException();
        }
        String commandName = arguments.get(0).toLowerCase();
        Class commandClass = (Class)commands.get(commandName);
        if (commandClass == null) {
            throw new IllegalArgumentException(String.format("Unrecognized command: %s", commandName));
        }
        Command command = (Command)commandClass.getConstructor(String.class).newInstance(commandName);
        if (command == null) {
            throw new IllegalArgumentException();
        }
        command.setArguments(arguments);
        command.validate();
        command.run();
    }

    private void initialize() {
    }

    static class ConsoleProgressReporter
    implements ProgressReporter {
        private String fDescription;
        private boolean fCanceled;
        private int fProgress;
        private int fMaximumProgress;
        private String fStatus;
        private int lastValue = Integer.MIN_VALUE;
        private String lastStatus;

        ConsoleProgressReporter() {
        }

        public void cancel() {
            this.fCanceled = true;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public int getMaximumProgress() {
            return this.fMaximumProgress;
        }

        public int getProgress() {
            return this.fProgress;
        }

        public String getStatus() {
            return this.fStatus;
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }

        public void setDescription(String description) {
            this.fDescription = description;
        }

        public void setMaximumProgress(int maximum) {
            this.fMaximumProgress = maximum;
        }

        public void setProgress(int progress) {
            this.fProgress = progress;
            double percent = (double)progress / (double)this.fMaximumProgress;
            int value = (int)Math.floor(percent * 100.0);
            if (value == this.lastValue) {
                return;
            }
            this.lastValue = value;
            System.err.printf("\r[%3.0f%%]", percent * 100.0);
            if (value == 100) {
                System.err.println();
            }
        }

        public void setStatus(String status) {
            if (status == null) {
                this.lastStatus = null;
                return;
            }
            if (status.equals(this.lastStatus)) {
                return;
            }
            this.lastStatus = status;
            System.err.printf("\r%s\n", status);
            this.fStatus = status;
        }
    }

    static class UninstallDescriptorsCommand
    extends Command {
        private List<DataDescriptor> fDescriptors = new ArrayList<DataDescriptor>();

        public UninstallDescriptorsCommand(String name) {
            super(name);
        }

        @Override
        public void run() {
            this.fProgress.setStatus("Uninstalling...");
            this.fProgress.setMaximumProgress(this.fDescriptors.size());
            for (DataDescriptor descriptor : this.fDescriptors) {
                try {
                    this.fProgress.setStatus(String.format("Uninstalling %s", descriptor.getDescription()));
                    this.fData.deleteIndex(descriptor.getId());
                }
                catch (ApplicationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fProgress.setProgress(this.fDescriptors.size());
            this.fProgress.setStatus("Done.");
        }

        @Override
        public void validate() throws IllegalArgumentException {
            if (this.fArguments.size() < 3) {
                throw new IllegalArgumentException(String.format("Usage: %s path/to/data-set data-id [ data-id2 ... ]", this.fName));
            }
            File file = new File((String)this.fArguments.get(1));
            this.validateDataSet(file);
            try {
                this.fData = (LuceneDataSet)this.fManager.open(file);
                List<DataDescriptor> installed = this.fData.getInstalledDataDescriptors();
                for (int i = 2; i < this.fArguments.size(); ++i) {
                    String id = (String)this.fArguments.get(i);
                    DataDescriptor target = new DataDescriptor(id, null);
                    int index = installed.indexOf(target);
                    if (index == -1) {
                        System.err.printf("Data with ID='%s' isn't installed\n", id);
                        continue;
                    }
                    this.fDescriptors.add(installed.get(index));
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class InstallDescriptorsCommand
    extends Command {
        Set<DataDescriptor> fDescriptors = new HashSet<DataDescriptor>();

        public InstallDescriptorsCommand(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.fProgress.setStatus("Installing...");
            this.fProgress.setMaximumProgress(this.fDescriptors.size());
            ArrayList<DataDescriptor> sorted = new ArrayList<DataDescriptor>(this.fDescriptors);
            Collections.sort(sorted);
            for (DataDescriptor descriptor : sorted) {
                try {
                    ChildProgressReporter childProgress = new ChildProgressReporter(this.fProgress);
                    try {
                        this.fData.installIndex(descriptor.getId(), descriptor.getDescription(), (ProgressReporter)childProgress);
                    }
                    finally {
                        childProgress.close();
                    }
                }
                catch (ApplicationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fProgress.setProgress(this.fDescriptors.size());
            this.fProgress.setStatus("Done.");
        }

        @Override
        public void validate() throws IllegalArgumentException {
            if (this.fArguments.size() < 3) {
                throw new IllegalArgumentException(String.format("Usage: %s path/to/data-set data-id [ data-id2 ... ]", this.fName));
            }
            File file = new File((String)this.fArguments.get(1));
            this.validateDataSet(file);
            try {
                this.fData = (LuceneDataSet)this.fManager.open(file);
                List<DataDescriptor> available = this.fData.getAvailableDataDescriptors();
                List<DataDescriptor> installed = this.fData.getInstalledDataDescriptors();
                for (int i = 2; i < this.fArguments.size(); ++i) {
                    String id = (String)this.fArguments.get(i);
                    if ("all".equals(id)) {
                        this.addAll(available, installed);
                        break;
                    }
                    DataDescriptor target = new DataDescriptor(id, null);
                    int index = available.indexOf(target);
                    if (index == -1) {
                        throw new IllegalArgumentException(String.format("This data set does not contain any data for ID='%s'", id));
                    }
                    if (installed.contains(target)) {
                        System.err.printf("Data with ID='%s' is already installed\n", id);
                        continue;
                    }
                    this.fDescriptors.add(available.get(index));
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        private void addAll(List<DataDescriptor> available, List<DataDescriptor> installed) {
            for (DataDescriptor descriptor : available) {
                if (installed.contains(descriptor)) continue;
                this.fDescriptors.add(descriptor);
            }
        }
    }

    static class ListDescriptorsCommand
    extends Command {
        public ListDescriptorsCommand(String name) {
            super(name);
        }

        @Override
        public void run() {
            String path = (String)this.fArguments.get(1);
            try {
                this.fData = (LuceneDataSet)this.fManager.open(new File(path));
                List<DataDescriptor> available = this.fData.getAvailableDataDescriptors();
                List<DataDescriptor> installed = this.fData.getInstalledDataDescriptors();
                System.out.println("Data ID\tDescription\tStatus");
                for (DataDescriptor descriptor : available) {
                    boolean isInstalled = installed.contains(descriptor);
                    String status = isInstalled ? "Installed" : "";
                    System.out.printf("%s\t%s\t%s\n", descriptor.getId(), descriptor.getDescription(), status);
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void validate() throws IllegalArgumentException {
            if (this.fArguments.size() < 2) {
                throw new IllegalArgumentException(String.format("Usage: %s path/to/data-set", this.fName));
            }
            File file = new File((String)this.fArguments.get(1));
            this.validateDataSet(file);
        }
    }

    public static class InstallDataSetCommand
    extends Command {
        private String fId;

        public InstallDataSetCommand(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File dataZipFile;
                String baseUrl = this.fFileUtils.findDataSetBaseUrl("http://www.genemania.org/plugin", this.fId);
                URL url = new URL(String.format("%s.zip", baseUrl));
                this.fProgress.setStatus("Installing...");
                this.fProgress.setMaximumProgress(2);
                int progress = 0;
                this.fProgress.setProgress(progress);
                ChildProgressReporter childProgress = new ChildProgressReporter(this.fProgress);
                try {
                    childProgress.setStatus(String.format("Downloading %s", url));
                    dataZipFile = this.fFileUtils.download(url, new File("."), (ProgressReporter)childProgress);
                }
                finally {
                    childProgress.close();
                }
                if (dataZipFile == null) {
                    return;
                }
                childProgress = new ChildProgressReporter(this.fProgress);
                try {
                    this.fFileUtils.unzip(dataZipFile, dataZipFile.getParentFile(), (ProgressReporter)childProgress);
                }
                finally {
                    childProgress.close();
                }
                dataZipFile.delete();
                this.fProgress.setStatus("Done.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void validate() throws IllegalArgumentException {
            try {
                if (this.fArguments.size() < 2) {
                    throw new IllegalArgumentException(String.format("Usage: %s data-set-id", this.fName));
                }
                String targetId = (String)this.fArguments.get(1);
                List<String> dataSets = this.fFileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
                for (String url : dataSets) {
                    String id = this.getDataSetId(url);
                    if (!targetId.equals(id)) continue;
                    this.fId = id;
                    return;
                }
                throw new IllegalArgumentException(String.format("Data set with ID='%s' doesn't exist", targetId));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class ListDataSetCommand
    extends Command {
        public ListDataSetCommand(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                Map<String, String> descriptions = this.fFileUtils.getDataSetDescriptions("http://www.genemania.org/plugin");
                Map<String, Long> sizes = this.fFileUtils.getDataSetSizes("http://www.genemania.org/plugin");
                List<String> dataSets = this.fFileUtils.getCompatibleDataSets("http://www.genemania.org/plugin", "1.1");
                System.out.printf("Data Set ID\tTotal Size\tDatabase Version\n", new Object[0]);
                for (String url : dataSets) {
                    String name = this.getDataSetId(url);
                    double size = (double)sizes.get(name).longValue() / 1024.0;
                    String description = descriptions.get(name);
                    System.out.printf("%s\t%.2f MB\t%s\n", name, size, description);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }
    }

    static abstract class Command {
        static final Pattern DATA_SET_PATTERN = Pattern.compile(".*?gmdata-(.*?)");
        protected List<String> fArguments;
        protected DataSetManager fManager;
        protected FileUtils fFileUtils;
        protected LuceneDataSet<?, ?, ?> fData;
        protected String fName;
        protected ProgressReporter fProgress;

        public Command(String name) {
            this.fName = name;
            this.fManager = AbstractPluginApp.createDataSetManager();
            this.fProgress = new ConsoleProgressReporter();
            this.fFileUtils = new FileUtils();
        }

        public void setArguments(List<String> arguments) {
            this.fArguments = arguments;
        }

        protected void validateDataSet(File file) {
            if (!this.fManager.isDataSet(file)) {
                throw new IllegalArgumentException(String.format("%s is not a GeneMANIA data set", file.toString()));
            }
        }

        protected String getDataSetId(String url) {
            Matcher matcher = DATA_SET_PATTERN.matcher(url);
            if (!matcher.matches()) {
                return null;
            }
            return matcher.group(1);
        }

        public abstract void run();

        public abstract void validate() throws IllegalArgumentException;
    }
}

