/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.VectorCrossValidator;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.plugin.apps.AbstractPluginDataApp;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IMediatorProvider;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.parsers.TabDelimitedQueryParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class AbstractValidationApp
extends AbstractPluginDataApp {
    @Option(name="--organism", required=true, usage="organism name")
    protected String fOrganismName;
    @Option(name="--folds", usage="number of folds to use for each query, defaults to 5")
    protected int fFolds = 5;
    @Option(name="--query", required=true, usage="name of file containing gene queries")
    protected String fQueryFile;
    @Option(name="--outfile", required=true, usage="name of output file to contain validation results")
    protected String fOutputFile;
    @Option(name="--auto-negatives", usage="force all non-positive genes to be negative")
    protected boolean fAutoNegatives = false;
    @Option(name="--method", usage="optional, network combining method, defaults to 'automatic'")
    protected String fCombiningMethod = "automatic";
    @Option(name="--seed", usage="optional, random seed to use when generating cross-validation folds, 0 (default) will select a seed based on system time")
    protected int fSeed = 0;
    @Option(name="--use-go-cache", usage="optional, use cached GO gene sets instead of genes in query file")
    protected boolean fUseGoCache = false;
    @Option(name="--min", usage="minimum number of positive genes per set")
    private Integer fMinimumGeneSetSize;
    @Option(name="--max", usage="maximum number of positive genes per set")
    private Integer fMaximumGeneSetSize;
    protected Organism fOrganism;
    private IQueryErrorHandler fErrorHandler;

    protected void initialize() throws ApplicationException, DataStoreException {
        try {
            this.checkPath(this.fDataPath);
            DataSetManager manager = AbstractValidationApp.createDataSetManager();
            this.fData = manager.open(new File(this.fDataPath));
            if (this.fThreads < 1) {
                this.fThreads = 1;
            }
            this.fOrganism = this.parseOrganism(this.fData, this.fOrganismName);
            if (this.fOrganism == null) {
                throw new ApplicationException(String.format("Unrecognized organism: %s", this.fOrganismName));
            }
            if (this.fVerbose) {
                Logger.getLogger((String)"org.genemania").setLevel(Level.INFO);
            }
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
        final Logger logger = Logger.getLogger(this.getClass());
        this.fErrorHandler = new IQueryErrorHandler(){

            @Override
            public void warn(String message) {
                logger.warn((Object)message);
            }

            @Override
            public void handleUnrecognizedNetwork(String network) {
                logger.warn((Object)network);
            }

            @Override
            public void handleUnrecognizedGene(String gene) {
                logger.warn((Object)gene);
            }

            @Override
            public void handleSynonym(String gene) {
            }

            @Override
            public void handleNetwork(InteractionNetwork network) {
            }
        };
    }

    protected Collection<Group<?, ?>> parseNetworks(String networkData, String excludeData, Organism organism) {
        TabDelimitedQueryParser parser = new TabDelimitedQueryParser();
        AttributeMediator attributeMediator = this.fData.getMediatorProvider().getAttributeMediator();
        Collection<Group<?, ?>> networks = parser.parseNetworks(networkData, organism, ",", this.fErrorHandler, attributeMediator);
        Collection<Group<?, ?>> excludedNetworks = parser.parseNetworks(excludeData, organism, ",", this.fErrorHandler, attributeMediator);
        HashSet excluded = new HashSet();
        for (Group<?, ?> group : excludedNetworks) {
            excluded.addAll(group.getNetworks());
        }
        ArrayList result = new ArrayList();
        for (Group<?, ?> group : networks) {
            HashSet members = new HashSet();
            for (Network<?> network : group.getNetworks()) {
                if (excluded.contains(network)) continue;
                members.add(network);
            }
            if (members.size() <= 0) continue;
            result.add(group.filter(members));
        }
        return result;
    }

    protected VectorCrossValidator createValidator(String networkData, String excludeData) throws ApplicationException {
        VectorCrossValidator vcv = new VectorCrossValidator();
        vcv.setCacheNamespace("user");
        IMediatorProvider provider = this.fData.getMediatorProvider();
        vcv.setGeneMediator(provider.getGeneMediator());
        vcv.setNetworkMediator(provider.getNetworkMediator());
        vcv.setNodeMediator(provider.getNodeMediator());
        vcv.setOrganismMediator(provider.getOrganismMediator());
        vcv.setAttributeMediator(provider.getAttributeMediator());
        vcv.setCacheDir(this.fData.getFullPath("cache"));
        vcv.setOrganismId(this.fOrganism.getId());
        if (networkData != null) {
            Collection<Group<?, ?>> networks = this.parseNetworks(networkData, excludeData, this.fOrganism);
            if (networks.size() == 0) {
                throw new ApplicationException("None of the subject networks you specified were recognized.");
            }
            vcv.setNetworkIds(this.collapseNetworks(networks));
            vcv.setAttrIds(this.collapseAttributeGroups(networks));
        }
        vcv.setCombiningMethodName(this.fCombiningMethod);
        vcv.setNumFolds(this.fFolds);
        vcv.setQueryFileName(this.fQueryFile);
        vcv.setAllNegCrossVal(this.fAutoNegatives);
        vcv.setThreads(this.fThreads);
        vcv.setSeed((long)this.fSeed);
        vcv.setUseCachedGoAnnotations(this.fUseGoCache);
        vcv.setMinimumGeneSetSize(this.fMinimumGeneSetSize);
        vcv.setMaxmimumGeneSetSize(this.fMaximumGeneSetSize);
        return vcv;
    }
}

