/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.cytoscape.NullCytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.LuceneDataSetFactory;
import org.genemania.plugin.parsers.TabDelimitedQueryParser;

public abstract class AbstractPluginApp {
    protected void checkPath(String path) throws ApplicationException {
        File file = new File(path);
        if (!file.exists()) {
            throw new ApplicationException(String.format("'%s' doesn't exist.", path));
        }
    }

    protected void checkFile(String path) throws ApplicationException {
        this.checkPath(path);
        File file = new File(path);
        if (!file.isFile()) {
            throw new ApplicationException(String.format("'%s' is not a file.", path));
        }
    }

    protected void checkWritable(String path) throws ApplicationException {
        File file = new File(path);
        if (file.isFile() && file.canWrite()) {
            return;
        }
        try {
            if (!file.exists() && file.createNewFile()) {
                file.delete();
                return;
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        throw new ApplicationException(String.format("Cannot create file: %s", path));
    }

    protected Organism parseOrganism(DataSet data, String name) throws DataStoreException {
        TabDelimitedQueryParser parser = new TabDelimitedQueryParser();
        return parser.parseOrganism(data, name);
    }

    static DataSetManager createDataSetManager() {
        DataSetManager dataSetManager = new DataSetManager();
        dataSetManager.addDataSetFactory(new LuceneDataSetFactory(dataSetManager, null, new FileUtils(), new NullCytoscapeUtils(), null), Collections.emptyMap());
        return dataSetManager;
    }
}

