/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class SystemUtils {
    public static boolean openBrowser(URL url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Windows")) {
                Runtime runtime = Runtime.getRuntime();
                Process p = runtime.exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()});
                return p.waitFor() == 0;
            }
            if (osName.startsWith("Mac OS")) {
                Class<?> fileManagerClass = Class.forName("com.apple.eio.FileManager");
                Method method = fileManagerClass.getDeclaredMethod("openURL", String.class);
                method.invoke(null, url.toString());
                return true;
            }
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(new String[]{"xdg-open", url.toString()});
            return p.waitFor() == 0;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static String escape(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger logger = Logger.getLogger(SystemUtils.class);
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String unescape(String data) {
        try {
            return URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger logger = Logger.getLogger(SystemUtils.class);
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

