/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import java.io.Reader;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.type.NetworkProcessingMethod;
import org.genemania.util.ProgressReporter;

public class ManiaUtils {
    public static final int QUERY_GENE_THRESHOLD = 6;
    private static final int DEFAULT_SPARSIFICATION = 50;

    public static UploadNetworkEngineRequestDto createRequest(DataImportSettings settings, Reader sourceData, ProgressReporter progress) {
        UploadNetworkEngineRequestDto request = new UploadNetworkEngineRequestDto();
        request.setLayout(settings.getDataLayout());
        request.setMethod(settings.getProcessingMethod());
        request.setNamespace("user");
        request.setOrganismId(settings.getOrganism().getId());
        request.setNetworkId(settings.getNetwork().getId());
        request.setProgressReporter(progress);
        request.setData(sourceData);
        int sparsification = 50;
        switch (settings.getDataLayout()) {
            case GEO_PROFILE: 
            case SPARSE_PROFILE: 
            case PROFILE: {
                request.setSparsification(sparsification);
                break;
            }
            case BINARY_NETWORK: {
                if (!request.getMethod().equals((Object)NetworkProcessingMethod.LOG_FREQUENCY)) break;
                request.setSparsification(sparsification);
            }
        }
        return request;
    }
}

