/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import ch.enterag.utils.zip.FileEntry;
import ch.enterag.utils.zip.Zip64File;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.genemania.plugin.Strings;
import org.genemania.util.ProgressReporter;

public class FileUtils {
    public static final String DEFAULT_BASE_URL = "http://www.genemania.org/plugin";
    public static final String DEFAULT_METADATA_URL = "http://www.genemania.org/plugin/versions.txt";
    public static final String DESCRIPTION_FILE = "descriptions.txt";
    public static final String SIZE_FILE = "sizes.txt";
    private static final int BUFFER_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(URL dataUrl, File destination, ProgressReporter progress) throws IOException {
        HttpURLConnection.setFollowRedirects(true);
        Proxy proxy = this.getProxy();
        URLConnection connection = dataUrl.openConnection(proxy);
        connection.setUseCaches(false);
        int totalBytes = connection.getContentLength();
        progress.setMaximumProgress(100);
        InputStream input = connection.getInputStream();
        String fileName = this.determineFileName(connection, destination);
        String fullPath = this.join(File.separator, new String[]{destination.getPath(), fileName});
        File outFile = new File(fullPath);
        outFile.getParentFile().mkdirs();
        outFile.createNewFile();
        FileOutputStream output = new FileOutputStream(outFile);
        try {
            try {
                byte[] buffer = new byte[0x100000];
                int length = input.read(buffer);
                long totalRead = 0L;
                while (length != -1) {
                    if (progress.isCanceled()) {
                        File file = null;
                        return file;
                    }
                    output.write(buffer, 0, length);
                    totalRead += (long)length;
                    if (totalBytes == -1) {
                        progress.setDescription(String.format(Strings.downloadProgress2_status, totalRead / 1000L));
                    } else {
                        progress.setProgress((int)(100.0 * (double)totalRead / (double)totalBytes));
                        progress.setDescription(String.format(Strings.downloadProgress_status, totalRead / 1000L, totalBytes / 1000));
                    }
                    length = input.read(buffer);
                }
            }
            finally {
                output.close();
                if (progress.isCanceled()) {
                    outFile.delete();
                }
            }
        }
        finally {
            input.close();
            progress.setDescription("");
        }
        return new File(fullPath);
    }

    String determineFileName(URLConnection connection, File basePath) throws IOException {
        String[] parts;
        int index;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        if (contentDisposition != null && (index = contentDisposition.indexOf("filename=")) > -1) {
            String fileName = contentDisposition.substring(index + "filename=".length());
            if (fileName.length() >= 2 && fileName.startsWith("\"") && fileName.endsWith("\"")) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
            if (fileName.length() > 0) {
                return fileName;
            }
        }
        if ((parts = connection.getURL().getPath().split("/")).length == 0) {
            throw new IOException();
        }
        return parts[parts.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getMetadata(URL url) throws IOException {
        URLConnection connection = url.openConnection(this.getProxy());
        InputStream metadataStream = connection.getInputStream();
        try {
            Properties properties = new Properties();
            properties.load(metadataStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            metadataStream.close();
        }
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    String join(String conjunct, String[] parts) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i != 0) {
                buffer.append(conjunct);
            }
            buffer.append(parts[i]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File zipPath, File destination, ProgressReporter progress) throws IOException {
        Zip64File file = new Zip64File(zipPath);
        try {
            int total = file.getFileEntries();
            progress.setMaximumProgress(100);
            List entries = file.getListFileEntries();
            int processed = 0;
            progress.setStatus(String.format(Strings.unzip_status, zipPath.getName()));
            for (FileEntry entry : entries) {
                if (progress.isCanceled()) {
                    return;
                }
                progress.setProgress((int)(100.0 * (double)(++processed) / (double)total));
                String name = entry.getName();
                progress.setDescription(String.format("%s", name));
                String entryPath = String.format("%s%s%s", destination.getPath(), File.separator, name);
                File entryFile = new File(entryPath);
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                entryFile.createNewFile();
                this.write(entryFile, (InputStream)file.openEntryInputStream(name));
            }
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File destination, InputStream in) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(destination);
            try {
                byte[] buffer = new byte[0x100000];
                int length = in.read(buffer, 0, buffer.length);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = in.read(buffer, 0, buffer.length);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public void delete(File path) throws IOException {
        if (path.isFile()) {
            path.delete();
            return;
        }
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                this.delete(file);
            }
            path.delete();
        }
    }

    public Reader getUncompressedReader(String path) throws IOException {
        return this.getUncompressedReader(new File(path));
    }

    public Reader getUncompressedReader(File file) throws IOException {
        return new InputStreamReader(this.getUncompressedStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUncompressedStream(File file) throws IOException {
        GZIPInputStream gZIPInputStream;
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(file));
        try {
            ((InputStream)stream).read();
            gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        ((InputStream)stream).close();
        return gZIPInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompatibleDataSets(String baseUrl, String schemaVersion) throws IOException {
        HttpURLConnection.setFollowRedirects(true);
        Proxy proxy = this.getProxy();
        String url = String.format("%s/data/schema-%s.txt", baseUrl, schemaVersion);
        URLConnection connection = new URL(url).openConnection(proxy);
        connection.setUseCaches(false);
        ArrayList<String> dataSets = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String line = reader.readLine();
            while (line != null) {
                dataSets.add(line);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return dataSets;
    }

    public String findDataSetBaseUrl(String baseUrl, String dataId) {
        return String.format("%s/data/gmdata-%s", baseUrl, dataId);
    }

    public Map<String, String> getDataSetDescriptions(String baseUrl) throws IOException {
        return this.getDataSetProperties(baseUrl, DESCRIPTION_FILE);
    }

    public Map<String, Long> getDataSetSizes(String baseUrl) throws IOException {
        Map<String, String> properties = this.getDataSetProperties(baseUrl, SIZE_FILE);
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            sizes.put(entry.getKey(), Long.decode(entry.getValue()));
        }
        return sizes;
    }

    Map<String, String> getDataSetProperties(String baseUrl, String name) throws IOException {
        HttpURLConnection.setFollowRedirects(true);
        Proxy proxy = this.getProxy();
        String url = String.format("%s/data/%s", baseUrl, name);
        URLConnection connection = new URL(url).openConnection(proxy);
        connection.setUseCaches(false);
        return this.getDataSetDescriptions(new InputStreamReader(connection.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getDataSetDescriptions(Reader source) throws IOException {
        Pattern pattern = Pattern.compile("([^#].*?)\\s*=\\s*(.*?)\\s*(#.*)?");
        HashMap<String, String> descriptions = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(source);
        try {
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    descriptions.put(matcher.group(1), matcher.group(2));
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return descriptions;
    }

    public File getUserHome() {
        return new File(System.getProperty("user.home"));
    }
}

