/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.settings.ColourSettings;
import savant.util.ColourKey;
import savant.util.MiscUtils;
import savant.view.variation.VariationController;

public abstract class VariationPlot
extends JPanel {
    protected static final double GAP_HEIGHT = 9.0;
    protected final VariationController controller;
    protected double unitHeight;
    protected double unitWidth;

    VariationPlot(VariationController vc) {
        this.controller = vc;
    }

    public Record pointToRecord(Point pt) {
        return this.pointToVariantRecord(pt);
    }

    public VariantRecord pointToVariantRecord(Point pt) {
        int logicalY = (int)((double)pt.y / this.unitHeight);
        List<VariantRecord> data = this.controller.getData();
        if (data != null && logicalY >= 0 && logicalY < data.size()) {
            return data.get(logicalY);
        }
        return null;
    }

    protected void labelVerticalAxis(Graphics2D g2) {
        List<VariantRecord> data = this.controller.getData();
        if (data.size() > 0) {
            int i;
            int[] ticks = MiscUtils.getTickPositions(this.controller.getVisibleRange());
            Color gridColor = ColourSettings.getColor(ColourKey.AXIS_GRID);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.setColor(gridColor);
            FontMetrics fm = g2.getFontMetrics();
            Area clipArea = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            double[] ys = new double[ticks.length];
            int index = 0;
            float labelX = 0.0f;
            for (i = 0; i < ticks.length && index < data.size(); ++i) {
                double y;
                int t = ticks[i];
                while (index < data.size() && t > data.get(index).getPosition()) {
                    ++index;
                    labelX = 0.0f;
                }
                ys[i] = y = (double)index * this.unitHeight;
                if (index <= 0 || index >= data.size() - 1) continue;
                String s = Integer.toString(t);
                Rectangle2D labelRect = fm.getStringBounds(s, g2);
                double baseline = y + (double)fm.getAscent() - (double)fm.getHeight() * 0.5;
                g2.drawString(s, labelX + 4.0f, (float)baseline);
                clipArea.subtract(new Area(new Rectangle2D.Double((double)labelX + 3.0, baseline - labelRect.getHeight() - 1.0, labelRect.getWidth() + 2.0, labelRect.getHeight() + 2.0)));
                labelX = (float)((double)labelX + (labelRect.getWidth() + 2.0));
            }
            g2.setClip(clipArea);
            for (i = 0; i < ticks.length; ++i) {
                double y = ys[i];
                g2.draw(new Line2D.Double(0.0, y, this.getWidth(), y));
            }
            g2.setClip(null);
        }
    }

    protected Area drawGapSizes(Graphics2D g2) {
        Area result = new Area();
        List<VariantRecord> data = this.controller.getData();
        if (data.size() > 1) {
            Color gridColor = ColourSettings.getColor(ColourKey.AXIS_GRID);
            g2.setFont(g2.getFont().deriveFont(0, 8.0f));
            FontMetrics fm = g2.getFontMetrics();
            g2.setColor(gridColor);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double y = this.unitHeight;
            double w = this.getWidth();
            for (int i = 1; i < data.size(); ++i) {
                int gapSize = data.get(i).getPosition() - data.get(i - 1).getPosition() - 1;
                if (gapSize > 0) {
                    String s = gapSize > 1 ? String.format("%d bases", gapSize) : "1 base";
                    Rectangle2D labelRect = fm.getStringBounds(s, g2);
                    double baseline = y + (double)fm.getAscent() - (double)fm.getHeight() * 0.5;
                    g2.drawString(s, (float)((w - labelRect.getWidth()) * 0.5), (float)baseline);
                    g2.draw(new Line2D.Double(0.0, y - 4.5, w, y - 4.5));
                    g2.draw(new Line2D.Double(0.0, y + 4.5, w, y + 4.5));
                    result.add(new Area(new Rectangle2D.Double(0.0, y - 4.5, w, 9.0)));
                }
                y += this.unitHeight;
            }
        }
        return result;
    }
}

