/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.swing.SwingUtilities;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.settings.ColourSettings;
import savant.settings.ResolutionSettings;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.MiscUtils;
import savant.view.variation.LDCalculator;
import savant.view.variation.LDRecord;
import savant.view.variation.VariationController;
import savant.view.variation.swing.VariantPopper;
import savant.view.variation.swing.VariationModule;
import savant.view.variation.swing.VariationPlot;

public class LDPlot
extends VariationPlot {
    private static final double AXIS_WIDTH = 90.0;
    private static final double LEGEND_MARGIN = 15.0;
    private static final double LEGEND_HEIGHT = 180.0;
    private static final double LEGEND_WIDTH = 15.0;
    private static final float TICK_LENGTH = 3.0f;
    private static final String OUT_OF_MEMORY_ERROR = "Zoom in to see data";
    private static final String UNPHASED_ERROR = "D\u2032 not calculated for unphased data";
    private static final Color[] HEATMAP_COLORS = new Color[]{ColourSettings.getColor(ColourKey.HEATMAP_LOW), ColourSettings.getColor(ColourKey.HEATMAP_MEDIUM), ColourSettings.getColor(ColourKey.HEATMAP_HIGH)};
    private LDCalculator calculator;
    private float[][] dPrimes;
    private float[][] rSquareds;
    private double x0;
    private double y0;
    private Area[] zones;
    private boolean memoryOK = true;

    LDPlot(VariationController vc) {
        super(vc);
        VariantPopper popper = new VariantPopper(this);
        this.addMouseListener(popper);
        this.addMouseMotionListener(popper);
    }

    synchronized void recalculate() {
        this.dPrimes = null;
        this.rSquareds = null;
        if (this.calculator != null) {
            this.calculator.cancel(true);
            this.calculator = null;
        }
        try {
            this.memoryOK = true;
            List<VariantRecord> data = this.controller.getData();
            int n = data.size();
            if (n < ResolutionSettings.getLDMaxLoci()) {
                boolean phased = true;
                for (int i = 0; i < n && phased; phased &= data.get(i).isPhased(), ++i) {
                }
                this.calculator = new LDCalculator(this.controller, phased){

                    @Override
                    protected Object doInBackground() throws Exception {
                        LDPlot.this.controller.getModule().showProgress("Calculating Linkage Disequilibrium\u2026", 0.0);
                        return super.doInBackground();
                    }

                    @Override
                    public void done() {
                        LDPlot.this.controller.getModule().showTabs();
                        LDPlot.access$002(LDPlot.this, this.dPrimes);
                        LDPlot.access$102(LDPlot.this, this.rSquareds);
                        LDPlot.this.repaint();
                        LDPlot.this.calculator = null;
                    }

                    @Override
                    public void showProgress(final double fract) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!this.isDone()) {
                                    LDPlot.this.controller.getModule().showProgress("Calculating Linkage Disequilibrium\u2026", fract);
                                }
                            }
                        });
                    }
                };
                this.calculator.execute();
            } else {
                this.memoryOK = false;
            }
        }
        catch (OutOfMemoryError x) {
            VariationModule.LOG.error((Object)"Out of memory calculating LD.");
            this.memoryOK = false;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP), 0.0f, this.getHeight(), ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM));
        g2.setPaint(gp0);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.memoryOK) {
            if (this.rSquareds != null) {
                float[][] ldData;
                float[][] fArray = ldData = this.controller.isDPrimeSelected() ? this.dPrimes : this.rSquareds;
                if (ldData != null && ldData.length != 0) {
                    int i;
                    int n = ldData.length;
                    double h = this.getHeight() / n;
                    double w = ((double)this.getWidth() - 90.0) * 2.0 / (double)n;
                    this.unitHeight = Math.min(h, w);
                    ColourAccumulator accumulator = new ColourAccumulator(null);
                    Color transparent = new Color(0, 0, 0, 0);
                    this.x0 = (double)this.getWidth() - 90.0;
                    this.y0 = ((double)this.getHeight() - (double)n * this.unitHeight) * 0.5;
                    Path2D[] zonePaths = new Path2D[n];
                    for (i = 0; i < n; ++i) {
                        for (int j = i + 1; j < n; ++j) {
                            Shape diamond = this.getDiamond(i, j);
                            if (Float.isNaN(ldData[i][j])) {
                                accumulator.addShape(transparent, diamond);
                                continue;
                            }
                            accumulator.addShape(LDPlot.createBlend(ldData[i][j]), diamond);
                            this.addToZone(diamond, zonePaths, i);
                            this.addToZone(diamond, zonePaths, j);
                        }
                    }
                    accumulator.fill(g2);
                    if (this.unitHeight > 10.0) {
                        g2.setColor(Color.BLACK);
                        g2.setStroke(new BasicStroke(0.5f));
                        accumulator.draw(g2);
                    }
                    this.drawAxis(g2);
                    this.drawLegend(g2);
                    this.zones = new Area[n];
                    for (i = 0; i < n; ++i) {
                        this.zones[i] = zonePaths[i] != null ? new Area(zonePaths[i]) : new Area();
                    }
                } else {
                    g2.setColor(Color.BLACK);
                    g2.setFont(VariationModule.MESSAGE_FONT.deriveFont(18.0f));
                    MiscUtils.drawMessage(g2, UNPHASED_ERROR, new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), 40.0f));
                }
            }
        } else {
            g2.setColor(Color.BLACK);
            g2.setFont(VariationModule.MESSAGE_FONT);
            MiscUtils.drawMessage(g2, OUT_OF_MEMORY_ERROR, new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), 40.0f));
        }
    }

    private void addToZone(Shape diamond, Path2D[] zones, int z) {
        if (zones[z] == null) {
            zones[z] = new Path2D.Double();
        }
        zones[z].append(diamond.getPathIterator(null), false);
    }

    private Shape getDiamond(int i, int j) {
        double dj = 0.5 * (double)(j - i - 1) * this.unitHeight;
        return MiscUtils.createPolygon(this.x0 - 0.5 * this.unitHeight - dj, this.y0 + ((double)i + 0.5) * this.unitHeight + dj, this.x0 - dj, this.y0 + (double)(i + 1) * this.unitHeight + dj, this.x0 - 0.5 * this.unitHeight - dj, this.y0 + ((double)i + 1.5) * this.unitHeight + dj, this.x0 - this.unitHeight - dj, this.y0 + (double)(i + 1) * this.unitHeight + dj);
    }

    private void drawAxis(Graphics2D g2) {
        List<VariantRecord> data = this.controller.getData();
        if (data != null) {
            ColourScheme cs = new ColourScheme(ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.INSERTED_BASE, ColourKey.DELETED_BASE);
            ColourAccumulator accumulator = new ColourAccumulator(cs);
            double y = this.y0;
            for (VariantRecord varRec : data) {
                Rectangle2D.Double rect = new Rectangle2D.Double((double)this.getWidth() - 90.0, y, 90.0, this.unitHeight);
                switch (varRec.getVariantType()) {
                    case SNP_A: {
                        accumulator.addBaseShape('A', rect);
                        break;
                    }
                    case SNP_C: {
                        accumulator.addBaseShape('C', rect);
                        break;
                    }
                    case SNP_G: {
                        accumulator.addBaseShape('G', rect);
                        break;
                    }
                    case SNP_T: {
                        accumulator.addBaseShape('T', rect);
                        break;
                    }
                    case INSERTION: {
                        accumulator.addShape(ColourKey.INSERTED_BASE, (Shape)rect);
                        break;
                    }
                    case DELETION: {
                        accumulator.addShape(ColourKey.DELETED_BASE, (Shape)rect);
                    }
                }
                y += this.unitHeight;
            }
            accumulator.fill(g2);
            if (this.unitHeight > 10.0) {
                y = this.y0;
                g2.setColor(ColourSettings.getColor(ColourKey.AXIS_GRID));
                Font tickFont = g2.getFont().deriveFont(0, 9.0f);
                g2.setFont(tickFont);
                FontMetrics fm = g2.getFontMetrics();
                float baselineOffset = (float)fm.getAscent() - (float)fm.getHeight() * 0.5f;
                for (VariantRecord varRec : data) {
                    String name = VariationController.getDisplayName(varRec);
                    Rectangle2D labelRect = fm.getStringBounds(name, g2);
                    double baseline = y + this.unitHeight * 0.5 + (double)baselineOffset;
                    g2.drawString(name, (float)((double)this.getWidth() - 90.0 + (90.0 - labelRect.getWidth()) * 0.5), (float)baseline);
                    y += this.unitHeight;
                }
            }
        }
    }

    private void drawLegend(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double legendRect = new Rectangle2D.Double(15.0, (double)this.getHeight() - 180.0 - 15.0, 15.0, 180.0);
        g2.setPaint(new GradientPaint(0.0f, (float)legendRect.getMinY(), LDPlot.createBlend(0.0), 0.0f, (float)legendRect.getCenterY(), LDPlot.createBlend(0.5)));
        g2.fill(new Rectangle2D.Double(((RectangularShape)legendRect).getX(), ((RectangularShape)legendRect).getY(), ((RectangularShape)legendRect).getWidth(), ((RectangularShape)legendRect).getHeight() * 0.5));
        g2.setPaint(new GradientPaint(0.0f, (float)legendRect.getCenterY(), LDPlot.createBlend(0.5), 0.0f, (float)legendRect.getMaxY(), LDPlot.createBlend(1.0)));
        g2.fill(new Rectangle2D.Double(((RectangularShape)legendRect).getX(), legendRect.getCenterY(), ((RectangularShape)legendRect).getWidth(), ((RectangularShape)legendRect).getHeight() * 0.5));
        g2.setColor(ColourSettings.getColor(ColourKey.INTERVAL_LINE));
        g2.draw(legendRect);
        float x = (float)legendRect.getMaxX();
        this.drawTick(g2, x, (float)legendRect.getMinY(), 0.0);
        this.drawTick(g2, x, (float)legendRect.getCenterY(), 0.5);
        this.drawTick(g2, x, (float)legendRect.getMaxY(), 1.0);
    }

    private void drawTick(Graphics2D g2, float x, float y, double val) {
        g2.draw(new Line2D.Float(x, y, x + 3.0f, y));
        FontMetrics fm = g2.getFontMetrics();
        g2.drawString(Double.toString(val), x + 3.0f + 1.0f, y + (float)fm.getAscent() - (float)fm.getHeight() * 0.5f);
    }

    private static Color createBlend(double val) {
        int i0 = 0;
        int i1 = 1;
        double w1 = val * 2.0;
        if (val > 0.5) {
            i0 = 1;
            i1 = 2;
            w1 -= 1.0;
        }
        double w0 = 1.0 - w1;
        return new Color((int)((double)HEATMAP_COLORS[i0].getRed() * w0 + (double)HEATMAP_COLORS[i1].getRed() * w1), (int)((double)HEATMAP_COLORS[i0].getGreen() * w0 + (double)HEATMAP_COLORS[i1].getGreen() * w1), (int)((double)HEATMAP_COLORS[i0].getBlue() * w0 + (double)HEATMAP_COLORS[i1].getBlue() * w1));
    }

    @Override
    public VariantRecord pointToVariantRecord(Point pt) {
        if ((double)pt.x >= (double)this.getWidth() - 90.0) {
            int logicalY = (int)(((double)pt.y - this.y0) / this.unitHeight);
            List<VariantRecord> data = this.controller.getData();
            if (data != null && logicalY >= 0 && logicalY < data.size()) {
                return data.get(logicalY);
            }
        }
        return null;
    }

    @Override
    public Record pointToRecord(Point pt) {
        Record result = this.pointToVariantRecord(pt);
        if (result == null) {
            int i = -1;
            for (int j = 0; j < this.zones.length; ++j) {
                if (!this.zones[j].contains(pt)) continue;
                if (i < 0) {
                    i = j;
                    continue;
                }
                List<VariantRecord> data = this.controller.getData();
                float d = this.dPrimes != null ? this.dPrimes[i][j] : Float.NaN;
                result = new LDRecord(data.get(i), data.get(j), d, this.rSquareds[i][j]);
                break;
            }
        }
        return result;
    }

    private void dumpLD(Writer output, boolean phased) throws IOException {
        List<VariantRecord> data = this.controller.getData();
        if (phased) {
            output.write("CHR\tPOS1\tPOS2\tN_CHR\tR^2\tD\tDprime\n");
            for (int i = 0; i < data.size(); ++i) {
                for (int j = i + 1; j < data.size(); ++j) {
                    output.write(String.format("%s\t%d\t%d\t%d\t%f\t0\t%f\n", this.controller.getReference(), data.get(i).getPosition(), data.get(j).getPosition(), this.controller.getParticipantCount(), Float.valueOf(this.rSquareds[i][j]), Float.valueOf(this.dPrimes[i][j])));
                }
            }
        } else {
            output.write("CHR\tPOS1\tPOS2\tN_INDV\tR^2\n");
            for (int i = 0; i < data.size(); ++i) {
                for (int j = i + 1; j < data.size(); ++j) {
                    output.write(String.format("%s\t%d\t%d\t%d\t%f\n", this.controller.getReference(), data.get(i).getPosition(), data.get(j).getPosition(), this.controller.getParticipantCount(), Float.valueOf(this.rSquareds[i][j])));
                }
            }
        }
        output.close();
    }

    static /* synthetic */ float[][] access$002(LDPlot x0, float[][] x1) {
        x0.dPrimes = x1;
        return x1;
    }

    static /* synthetic */ float[][] access$102(LDPlot x0, float[][] x1) {
        x0.rSquareds = x1;
        return x1;
    }
}

