/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.VariantDataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.event.DataRetrievalEvent;
import savant.api.event.LocationChangedEvent;
import savant.api.event.TrackEvent;
import savant.api.util.Listener;
import savant.api.util.RangeUtils;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.controller.TrackController;
import savant.settings.ResolutionSettings;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.view.tracks.VariantTrack;
import savant.view.variation.LDRecord;
import savant.view.variation.MergedVariantRecord;
import savant.view.variation.PaddedVariantRecord;
import savant.view.variation.swing.VariationModule;

public class VariationController
implements Listener<DataRetrievalEvent> {
    static final Log LOG = LogFactory.getLog(VariationController.class);
    private static final Comparator<VariantRecord> VARIANT_COMPARATOR = new Comparator<VariantRecord>(){

        @Override
        public int compare(VariantRecord t, VariantRecord t1) {
            return new CompareToBuilder().append((Object)t.getReference(), (Object)t1.getReference()).append(t.getPosition(), t1.getPosition()).toComparison();
        }
    };
    private static VariationController instance;
    private List<VariantTrack> tracks = new ArrayList<VariantTrack>();
    private List<List<VariantRecord>> rawData = new ArrayList<List<VariantRecord>>();
    private List<VariantRecord> aggregateData = null;
    private String[] participants = new String[0];
    private Set<String> controls = new HashSet<String>();
    private String visibleRef;
    private Range visibleRange;
    private VariationModule module;

    private VariationController() {
        LocationController.getInstance().addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                String ref = event.getReference();
                RangeAdapter r = event.getRange();
                if (!ref.equals(VariationController.this.visibleRef) || !RangeUtils.contains(VariationController.this.visibleRange, r)) {
                    VariationController.this.setLocation(ref, (Range)r);
                }
            }
        });
        TrackController.getInstance().addListener(new Listener<TrackEvent>(){

            @Override
            public void handleEvent(TrackEvent event) {
                if (event.getTrack().getDataFormat() == DataFormat.VARIANT) {
                    VariantTrack t = (VariantTrack)event.getTrack();
                    switch (event.getType()) {
                        case ADDED: {
                            VariationController.this.tracks.add(t);
                            VariationController.this.rawData.add(null);
                            t.addListener(VariationController.this);
                            if (!VariationController.this.controls.contains(t.getName())) break;
                            VariationController.this.controls.addAll(Arrays.asList(t.getParticipantNames()));
                            break;
                        }
                        case REMOVED: {
                            int index = VariationController.this.tracks.indexOf(t);
                            VariationController.this.tracks.remove(index);
                            VariationController.this.rawData.remove(index);
                            t.removeListener(VariationController.this);
                            if (VariationController.this.controls.contains(t.getName())) {
                                VariationController.this.controls.remove(t.getName());
                                VariationController.this.controls.removeAll(Arrays.asList(t.getParticipantNames()));
                            }
                            VariationController.this.recalculate();
                        }
                    }
                }
            }
        });
    }

    public static VariationController getInstance() {
        if (instance == null) {
            instance = new VariationController();
        }
        return instance;
    }

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        int index;
        if (evt.getRange().equals(this.visibleRange) && (index = this.tracks.indexOf(evt.getTrack())) >= 0) {
            switch (evt.getType()) {
                case STARTED: {
                    this.rawData.set(index, null);
                    this.module.showProgress("Retrieving variant data\u2026", -1.0);
                    break;
                }
                case COMPLETED: {
                    if (evt.getData() != null) {
                        this.rawData.set(index, evt.getData());
                    } else {
                        this.rawData.set(index, new ArrayList(0));
                    }
                    LOG.trace((Object)("Received " + this.rawData.get(index).size() + " records for " + evt.getTrack() + "; recalculating."));
                    this.recalculate();
                    break;
                }
                case FAILED: {
                    LOG.info((Object)("Received " + evt.getError() + " error for " + evt.getTrack()));
                    this.module.showMessage(MiscUtils.getMessage(evt.getError()));
                }
            }
        }
    }

    public synchronized List<VariantRecord> getData() {
        if (this.aggregateData == null) {
            int n = 0;
            int i = 0;
            ArrayList<String> names = new ArrayList<String>();
            for (VariantTrack t : this.tracks) {
                List<VariantRecord> trackData;
                if ((trackData = this.rawData.get(i++)) == null) continue;
                if (this.aggregateData == null) {
                    this.aggregateData = new ArrayList<VariantRecord>(trackData.size());
                }
                for (VariantRecord rec : trackData) {
                    int index = Collections.binarySearch(this.aggregateData, rec, VARIANT_COMPARATOR);
                    if (index < 0) {
                        int insertionPos = -index - 1;
                        if (LOG.isDebugEnabled()) {
                            String before = insertionPos > 0 ? this.aggregateData.get(insertionPos - 1).toString() : "START";
                            String after = insertionPos < this.aggregateData.size() ? this.aggregateData.get(insertionPos).toString() : "END";
                            LOG.debug((Object)("Inserting " + rec + " after " + before + " and before " + after));
                        }
                        this.aggregateData.add(insertionPos, new PaddedVariantRecord(rec, n));
                        continue;
                    }
                    VariantRecord oldRec = this.aggregateData.get(index);
                    LOG.debug((Object)("Merging " + rec + " into " + oldRec + " padding " + (n - oldRec.getParticipantCount())));
                    this.aggregateData.set(index, new MergedVariantRecord(oldRec, rec, n - oldRec.getParticipantCount()));
                }
                names.addAll(Arrays.asList(((VariantDataSourceAdapter)((Object)t.getDataSource())).getParticipants()));
                n += t.getParticipantCount();
            }
            this.participants = names.toArray(new String[0]);
        }
        return this.aggregateData;
    }

    public Set<String> getControls() {
        for (VariantTrack t : this.tracks) {
            if (!this.controls.contains(t.getName())) continue;
            this.controls.removeAll(Arrays.asList(t.getParticipantNames()));
        }
        return this.controls;
    }

    public void setControls(Collection<String> value) {
        this.controls.clear();
        this.controls.addAll(value);
        for (VariantTrack t : this.tracks) {
            if (!this.controls.contains(t.getName())) continue;
            this.controls.addAll(Arrays.asList(t.getParticipantNames()));
        }
    }

    public boolean isAControl(String p) {
        return this.controls.contains(p);
    }

    public String[] getParticipants() {
        return this.participants;
    }

    public int getParticipantCount() {
        return this.participants.length;
    }

    public VariantTrack[] getTracks() {
        return this.tracks.toArray(new VariantTrack[0]);
    }

    public void setLocation(String ref, Range r) {
        this.visibleRef = ref;
        this.setVisibleRange(r);
    }

    public Range getVisibleRange() {
        return this.visibleRange;
    }

    void setVisibleRange(Range r) {
        if (!r.equals(this.visibleRange)) {
            this.visibleRange = r;
            this.module.visibleRangeChanged(this.visibleRef, r);
            if (r.getLength() <= ResolutionSettings.getVariantLowToHighThreshold()) {
                for (VariantTrack t : this.tracks) {
                    t.requestData(this.visibleRef, this.visibleRange);
                }
            }
        }
    }

    public void setVisibleRange(int start) {
        if (start != this.visibleRange.getFrom()) {
            this.setVisibleRange(new Range(start, Math.min(start + this.visibleRange.getLength(), LocationController.getInstance().getMaxRangeEnd())));
        }
    }

    public String getReference() {
        return this.visibleRef;
    }

    public void zoomOut() {
        this.zoomToLength(this.visibleRange.getLength() * 2);
    }

    public void zoomIn() {
        this.zoomToLength(this.visibleRange.getLength() / 2);
    }

    private void zoomToLength(int length) {
        int maxLen = LocationController.getInstance().getMaxRangeEnd();
        if (length > maxLen) {
            length = maxLen;
        } else if (length < 1) {
            length = 1;
        }
        LOG.trace((Object)("Zooming to length " + length));
        int from = (this.visibleRange.getFrom() + 1 + this.visibleRange.getTo() - length) / 2;
        int to = from + length - 1;
        if (from < 1) {
            to += 1 - from;
            from = 1;
        }
        if (to > maxLen) {
            from -= to - maxLen;
            to = maxLen;
            if (from < 1) {
                from = 1;
            }
        }
        this.setVisibleRange(new Range(from, to));
    }

    public void navigateToRecord(Record rec) {
        if (rec != null) {
            Range r;
            if (rec instanceof LDRecord) {
                int pos1;
                List<VariantRecord> recs = ((LDRecord)rec).getConstituents();
                int pos0 = recs.get(0).getPosition();
                r = pos0 < (pos1 = recs.get(1).getPosition()) ? new Range(pos0, pos1) : new Range(pos1, pos0);
            } else {
                int pos = ((VariantRecord)rec).getPosition();
                r = new Range(pos, pos);
            }
            LocationController.getInstance().setLocation(this.visibleRef, (Range)RangeUtils.addMargin(r));
        }
    }

    public void updateStatusBar(VariantRecord rec) {
        if (rec != null) {
            GraphPaneController.getInstance().setMouseXPosition(rec.getPosition());
        } else {
            GraphPaneController.getInstance().setMouseXPosition(-1);
        }
    }

    void recalculate() {
        for (List<VariantRecord> trackData : this.rawData) {
            if (trackData != null) continue;
            return;
        }
        this.module.showProgress("Aggregating variant data\u2026", -1.0);
        this.aggregateData = null;
        this.module.recalculated(this.getData());
    }

    public void cancelDataRequests() {
        LOG.info((Object)("Cancelling data requests for " + this.tracks.size() + " variant tracks."));
        for (VariantTrack t : this.tracks) {
            t.cancelDataRequest();
        }
    }

    public VariationModule getModule() {
        if (this.module == null) {
            this.module = new VariationModule(this);
        }
        return this.module;
    }

    public boolean isDPrimeSelected() {
        return this.module.isDPrimeSelected();
    }

    public static String getDisplayName(VariantRecord rec) {
        String result = rec.getName();
        if (result == null || result.isEmpty()) {
            result = rec.getReference() + ":" + rec.getPosition();
        }
        return result;
    }
}

