/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.FrameAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.data.DataFormat;
import savant.api.data.Record;
import savant.api.event.DataRetrievalEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Resolution;
import savant.controller.TrackController;
import savant.exception.RenderingException;
import savant.exception.SavantTrackCreationCancelledException;
import savant.plugin.SavantPanelPlugin;
import savant.selection.SelectionController;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.Controller;
import savant.util.DrawingMode;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.util.Range;
import savant.util.RemoteFileCache;
import savant.view.tracks.TrackRenderer;

public abstract class Track
extends Controller<DataRetrievalEvent>
implements TrackAdapter {
    private static final Log LOG = LogFactory.getLog(Track.class);
    protected static final RenderingException ZOOM_MESSAGE = new RenderingException(MiscUtils.MAC ? "Zoom in to see data\nTo view data at this range, change Preferences > Track Resolutions" : "Zoom in to see data\nTo view data at this range, change Edit > Preferences > Track Resolutions", 0);
    private final String name;
    private ColourScheme colourScheme;
    private List<Record> dataInRange;
    protected DrawingMode drawingMode = DrawingMode.STANDARD;
    protected final TrackRenderer renderer;
    private final DataSourceAdapter dataSource;
    private DataRetriever retriever;
    protected RecordFilterAdapter filter;
    private FrameAdapter frame;

    protected Track(DataSourceAdapter dataSource, TrackRenderer renderer) throws SavantTrackCreationCancelledException {
        this.dataSource = dataSource;
        this.renderer = renderer;
        String n = this.getUniqueName(dataSource.getName());
        if (n == null) {
            throw new SavantTrackCreationCancelledException();
        }
        this.name = n;
        renderer.setTrackName(this.name);
        this.addListener(renderer);
    }

    public String toString() {
        return this.name;
    }

    private String getUniqueName(String name) {
        String result = name;
        while (TrackController.getInstance().containsTrack(result)) {
            if ((result = DialogUtils.displayInputMessage("Duplicate Track", "A track with that name already exists. Please enter a new name:", result)) != null) continue;
            return null;
        }
        return result;
    }

    public ColourScheme getColourScheme() {
        if (this.colourScheme == null) {
            this.colourScheme = this.getDefaultColourScheme();
        }
        return this.colourScheme;
    }

    public void setColor(ColourKey key, Color color) {
        this.getColourScheme().setColor(key, color);
    }

    public abstract ColourScheme getDefaultColourScheme();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Record> getDataInRange() {
        return this.dataInRange;
    }

    @Override
    public List<Record> getSelectedDataInRange() {
        return SelectionController.getInstance().getSelections(this.getName());
    }

    @Override
    public DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    @Override
    public DrawingMode[] getValidDrawingModes() {
        return new DrawingMode[]{DrawingMode.STANDARD};
    }

    @Override
    public void setDrawingMode(DrawingMode mode) {
        this.drawingMode = mode;
        this.frame.drawModeChanged(this);
    }

    @Override
    public DataSourceAdapter getDataSource() {
        return this.dataSource;
    }

    @Override
    public DataFormat getDataFormat() {
        return this.dataSource.getDataFormat();
    }

    public boolean containsReference(String ref) {
        return this.dataSource.getReferenceNames().contains(ref) || this.dataSource.getReferenceNames().contains(MiscUtils.homogenizeSequence(ref));
    }

    @Override
    public JPanel getLayerCanvas(SavantPanelPlugin plugin) {
        return this.frame.getLayerCanvas(plugin, true);
    }

    @Override
    public JPanel getLayerCanvas() {
        return this.getLayerCanvas(null);
    }

    @Override
    public int transformXPixel(double pix) {
        return this.frame.getGraphPane().transformXPixel(pix);
    }

    @Override
    public double transformXPos(int pos) {
        return this.frame.getGraphPane().transformXPos(pos);
    }

    @Override
    public double transformYPixel(double pix) {
        return this.frame.getGraphPane().transformYPixel(pix);
    }

    @Override
    public double transformYPos(double pos) {
        return this.frame.getGraphPane().transformYPos(pos);
    }

    @Override
    public Rectangle getRecordBounds(Record rec) {
        Shape s = this.renderer.recordToShapeMap.get(rec);
        if (s != null) {
            return s.getBounds();
        }
        return null;
    }

    @Override
    public Record getRecordAtPos(Point pt) {
        for (Record r : this.renderer.recordToShapeMap.keySet()) {
            Shape s = this.renderer.recordToShapeMap.get(r);
            if (!s.contains(new Point2D.Double(pt.x, pt.y))) continue;
            return r;
        }
        return null;
    }

    public FrameAdapter getFrame() {
        return this.frame;
    }

    public void setFrame(FrameAdapter f, DrawingMode initialMode) {
        this.frame = f;
        if (initialMode != null) {
            this.drawingMode = initialMode;
        }
        this.addListener(this.frame);
    }

    public TrackRenderer getRenderer() {
        return this.renderer;
    }

    public abstract void prepareForRendering(String var1, Range var2);

    @Override
    public void repaint() {
        this.frame.getGraphPane().setRenderForced();
        this.frame.getGraphPane().repaint();
    }

    public void repaintSelection() {
        this.frame.getGraphPane().repaint();
    }

    @Override
    public boolean isSelectionAllowed() {
        return this.renderer.selectionAllowed(false);
    }

    @Override
    public AxisType getXAxisType(Resolution res) {
        return AxisType.INTEGER;
    }

    @Override
    public AxisType getYAxisType(Resolution res) {
        return AxisType.NONE;
    }

    public void requestData(String reference, Range range) {
        if (this.retriever != null) {
            if (this.retriever.reference.equals(reference) && this.retriever.range.equals(range)) {
                LOG.debug((Object)("Nothing to request, already busy retrieving " + reference + ":" + range));
                return;
            }
            LOG.debug((Object)("You're wasting your time on " + reference + ":" + range));
        }
        this.dataInRange = null;
        this.fireEvent(new DataRetrievalEvent(this, range));
        this.retriever = new DataRetriever(reference, range, this.filter);
        this.retriever.start();
        try {
            if (this.retriever != null) {
                this.retriever.join(1000L);
                if (this.retriever != null && this.retriever.isAlive()) {
                    LOG.trace((Object)"Join timed out, putting up progress-bar.");
                }
            }
        }
        catch (InterruptedException ix) {
            LOG.error((Object)"DataRetriever interrupted during join.", (Throwable)ix);
            this.retriever = null;
        }
    }

    private void fireDataRetrievalCompleted(final Range r) {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                Track.this.fireEvent(new DataRetrievalEvent((TrackAdapter)Track.this, Track.this.dataInRange, (RangeAdapter)r));
            }
        });
    }

    private void fireDataRetrievalFailed(final Throwable x, final Range r) {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                Track.this.fireEvent(new DataRetrievalEvent((TrackAdapter)Track.this, x, (RangeAdapter)r));
            }
        });
    }

    public void cancelDataRequest() {
        if (this.retriever != null) {
            this.retriever.interrupt();
        }
    }

    public void saveNullData(Range r) {
        this.dataInRange = null;
        this.fireDataRetrievalCompleted(r);
    }

    protected synchronized List<Record> retrieveData(String ref, Range r, Resolution res, RecordFilterAdapter filter) throws Exception {
        return this.getDataSource().getRecords(ref, r, res, filter);
    }

    private class DataRetriever
    extends Thread {
        String reference;
        Range range;
        RecordFilterAdapter filter;
        private final MemoryMonitor memoryMonitor;

        DataRetriever(String ref, Range r, RecordFilterAdapter filt) {
            super("DataRetriever-" + ref + ":" + r);
            this.reference = ref;
            this.range = r;
            this.filter = filt;
            this.memoryMonitor = new MemoryMonitor(this);
        }

        @Override
        public void run() {
            try {
                this.memoryMonitor.start();
                LOG.debug((Object)("Retrieving data for " + Track.this.name + "(" + this.reference + ":" + this.range + ")"));
                Track.this.dataInRange = Track.this.retrieveData(this.reference, this.range, Track.this.getResolution(this.range), this.filter);
                if (this.isInterrupted()) {
                    LOG.info((Object)(Track.this.name + " was interrupted."));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Retrieved " + (Track.this.dataInRange != null ? Integer.toString(Track.this.dataInRange.size()) : "no") + " records for " + Track.this.name + "(" + this.reference + ":" + this.range + ")"));
                    }
                    Track.this.fireDataRetrievalCompleted(this.range);
                }
            }
            catch (InterruptedException x) {
                if (this.memoryMonitor.didWarn()) {
                    Track.this.fireDataRetrievalFailed(new Exception("Retrieval stopped due to memory warning"), this.range);
                } else {
                    Track.this.fireDataRetrievalFailed(new Exception("Data retrieval cancelled"), this.range);
                }
            }
            catch (Throwable x) {
                if (NetworkUtils.isStreamCached(Track.this.dataSource.getURI())) {
                    LOG.info((Object)("Cached read failed for " + this.getName() + " with " + MiscUtils.getMessage(x) + "; deleting cache file and retrying."));
                    try {
                        RemoteFileCache.removeCacheEntry(Track.this.dataSource.getURI().toString());
                        Track.this.dataInRange = Track.this.retrieveData(this.reference, this.range, Track.this.getResolution(this.range), this.filter);
                        Track.this.fireDataRetrievalCompleted(this.range);
                    }
                    catch (Throwable x2) {
                        LOG.error((Object)"Data retrieval failed twice.", x2);
                        Track.this.fireDataRetrievalFailed(x2, this.range);
                    }
                }
                LOG.error((Object)"Data retrieval failed.", x);
                Track.this.fireDataRetrievalFailed(x, this.range);
            }
            this.memoryMonitor.interrupt();
            Track.this.retriever = null;
        }
    }

    private static class MemoryMonitor
    extends Thread {
        private final Thread thread;
        private int MEMORY_LIMIT = 20;
        private boolean warned;

        public MemoryMonitor(DataRetriever r) {
            this.thread = r;
        }

        public boolean didWarn() {
            return this.warned;
        }

        @Override
        public void run() {
            long freeMemory;
            Runtime runtime = Runtime.getRuntime();
            NumberFormat format = NumberFormat.getInstance();
            do {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            } while ((freeMemory = runtime.freeMemory() / 1024L * 1024L) >= (long)this.MEMORY_LIMIT);
            this.warned = true;
            this.thread.interrupt();
        }
    }
}

