/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.util.Resolution;
import savant.data.sources.TabixDataSource;
import savant.exception.SavantTrackCreationCancelledException;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.Range;
import savant.view.tracks.IntervalTrack;
import savant.view.tracks.RichIntervalTrackRenderer;
import savant.view.tracks.Track;

public class RichIntervalTrack
extends Track {
    private static final Log LOG = LogFactory.getLog(RichIntervalTrack.class);
    private boolean itemRGBEnabled = false;
    private boolean scoreEnabled = false;
    private boolean alternateName = false;

    public RichIntervalTrack(DataSourceAdapter ds) throws SavantTrackCreationCancelledException {
        super(ds, new RichIntervalTrackRenderer());
        if (ds instanceof TabixDataSource) {
            this.alternateName = ((TabixDataSource)ds).prefersAlternateName();
        }
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        if (res == Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving data...");
            this.requestData(ref, r);
        } else {
            this.renderer.addInstruction(DrawingInstruction.ERROR, ZOOM_MESSAGE);
            this.saveNullData(r);
        }
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        this.renderer.addInstruction(DrawingInstruction.MODE, (Object)this.getDrawingMode());
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
        this.renderer.addInstruction(DrawingInstruction.ITEMRGB, this.itemRGBEnabled);
        this.renderer.addInstruction(DrawingInstruction.SCORE, this.scoreEnabled);
        this.renderer.addInstruction(DrawingInstruction.ALTERNATE_NAME, this.alternateName);
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.FORWARD_STRAND, ColourKey.REVERSE_STRAND, ColourKey.INTERVAL_LINE, ColourKey.INTERVAL_TEXT);
    }

    @Override
    public DrawingMode[] getValidDrawingModes() {
        return new DrawingMode[]{DrawingMode.STANDARD, DrawingMode.SQUISH};
    }

    public void toggleItemRGBEnabled() {
        this.itemRGBEnabled = !this.itemRGBEnabled;
        this.renderer.addInstruction(DrawingInstruction.ITEMRGB, this.itemRGBEnabled);
    }

    public void toggleScoreEnabled() {
        this.scoreEnabled = !this.scoreEnabled;
        this.renderer.addInstruction(DrawingInstruction.SCORE, this.scoreEnabled);
    }

    public void toggleAlternateName() {
        this.alternateName = !this.alternateName;
        this.renderer.addInstruction(DrawingInstruction.ALTERNATE_NAME, this.alternateName);
    }

    public boolean isUsingAlternateName() {
        return this.alternateName;
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return IntervalTrack.getDefaultModeResolution((Range)range);
    }
}

