/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.httpclient.NameValuePair;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.adapter.BookmarkAdapter;
import savant.api.event.GenomeChangedEvent;
import savant.api.event.LocationChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.controller.TrackController;
import savant.util.Bookmark;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.view.icon.SavantIconFactory;
import savant.view.swing.Savant;
import savant.view.tracks.Track;

public class NavigationBar
extends JPanel {
    private static final Dimension LOCATION_SIZE = new Dimension(270, 22);
    private static final Dimension LENGTH_SIZE = new Dimension(100, 22);
    private static final Dimension ICON_SIZE = MiscUtils.MAC ? new Dimension(50, 23) : new Dimension(27, 27);
    private LocationController locationController = LocationController.getInstance();
    JComboBox locationField;
    private JLabel lengthLabel;
    private String lastPoppedUp = "INVALID";
    private boolean currentlyPopulating = false;

    NavigationBar() {
        JButton undoButton;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        String buttonStyle = "segmentedCapsule";
        String shortcutMod = MiscUtils.MAC ? "Cmd" : "Ctrl";
        this.add(NavigationBar.getRigidPadding());
        JButton loadGenomeButton = (JButton)this.add(new JButton(""));
        loadGenomeButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.GENOME));
        loadGenomeButton.setToolTipText("Load or change genome");
        loadGenomeButton.setFocusable(false);
        loadGenomeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Savant.getInstance().showOpenGenomeDialog();
            }
        });
        loadGenomeButton.putClientProperty("JButton.buttonType", buttonStyle);
        loadGenomeButton.putClientProperty("JButton.segmentPosition", "first");
        loadGenomeButton.setPreferredSize(ICON_SIZE);
        loadGenomeButton.setMinimumSize(ICON_SIZE);
        loadGenomeButton.setMaximumSize(ICON_SIZE);
        JButton loadTrackButton = (JButton)this.add(new JButton(""));
        loadTrackButton.setFocusable(false);
        loadTrackButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.TRACK));
        loadTrackButton.setToolTipText("Load a track");
        loadTrackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Savant.getInstance().openTrack();
            }
        });
        loadTrackButton.putClientProperty("JButton.buttonType", buttonStyle);
        loadTrackButton.putClientProperty("JButton.segmentPosition", "last");
        loadTrackButton.setPreferredSize(ICON_SIZE);
        loadTrackButton.setMinimumSize(ICON_SIZE);
        loadTrackButton.setMaximumSize(ICON_SIZE);
        if (!Savant.getInstance().isStandalone()) {
            this.add(loadGenomeButton);
            this.add(loadTrackButton);
            this.add(NavigationBar.getRigidPadding());
            this.add(NavigationBar.getRigidPadding());
        } else {
            loadGenomeButton.setVisible(false);
            loadTrackButton.setVisible(false);
        }
        JLabel rangeText = new JLabel("Location ");
        this.add(rangeText);
        String[] a = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " ", " "};
        this.locationField = new JComboBox<String>(a);
        this.locationField.setEditable(true);
        this.locationField.setRenderer(new ReferenceListRenderer());
        this.locationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!NavigationBar.this.currentlyPopulating && ae.getActionCommand().equals("comboBoxChanged")) {
                    String itemText = NavigationBar.this.locationField.getSelectedItem().toString();
                    int lastBracketPos = itemText.lastIndexOf(40);
                    if (lastBracketPos > 0) {
                        itemText = itemText.substring(lastBracketPos + 1, itemText.length() - 1);
                    }
                    NavigationBar.this.setRangeFromText(itemText);
                }
            }
        });
        this.locationField.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
                String text = (String)NavigationBar.this.locationField.getEditor().getItem();
                if (!text.equals(NavigationBar.this.lastPoppedUp)) {
                    try {
                        NavigationBar.this.setCursor(Cursor.getPredefinedCursor(3));
                        NavigationBar.this.populateCombo();
                    }
                    finally {
                        NavigationBar.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent pme) {
            }
        });
        Component textField = this.locationField.getEditor().getEditorComponent();
        textField.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    NavigationBar.this.locationField.showPopup();
                } else if (evt.getModifiers() == 1) {
                    switch (evt.getKeyCode()) {
                        case 37: {
                            NavigationBar.this.locationController.shiftRangeLeft();
                            evt.consume();
                            break;
                        }
                        case 39: {
                            NavigationBar.this.locationController.shiftRangeRight();
                            evt.consume();
                            break;
                        }
                        case 38: {
                            NavigationBar.this.locationController.zoomIn();
                            evt.consume();
                            break;
                        }
                        case 40: {
                            NavigationBar.this.locationController.zoomOut();
                            evt.consume();
                            break;
                        }
                        case 36: {
                            NavigationBar.this.locationController.shiftRangeFarLeft();
                            evt.consume();
                            break;
                        }
                        case 35: {
                            NavigationBar.this.locationController.shiftRangeFarRight();
                            evt.consume();
                        }
                    }
                }
            }
        });
        this.add(this.locationField);
        this.locationField.setToolTipText("Current display range");
        this.locationField.setPreferredSize(LOCATION_SIZE);
        this.locationField.setMaximumSize(LOCATION_SIZE);
        this.locationField.setMinimumSize(LOCATION_SIZE);
        this.add(NavigationBar.getRigidPadding());
        JButton goButton = (JButton)this.add(new JButton("  Go  "));
        goButton.putClientProperty("JButton.buttonType", buttonStyle);
        goButton.putClientProperty("JButton.segmentPosition", "only");
        goButton.setToolTipText("Go to specified range (Enter)");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.setRangeFromText(NavigationBar.this.locationField.getEditor().getItem().toString());
            }
        });
        this.add(NavigationBar.getRigidPadding());
        JLabel l = new JLabel("Length: ");
        this.add(l);
        this.lengthLabel = (JLabel)this.add(new JLabel());
        this.lengthLabel.setToolTipText("Length of the current range");
        this.lengthLabel.setPreferredSize(LENGTH_SIZE);
        this.lengthLabel.setMaximumSize(LENGTH_SIZE);
        this.lengthLabel.setMinimumSize(LENGTH_SIZE);
        this.add(Box.createGlue());
        double screenwidth = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        JButton afterGo = null;
        afterGo = undoButton = (JButton)this.add(new JButton(""));
        undoButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.UNDO));
        undoButton.setToolTipText("Undo range change (" + shortcutMod + "+Z)");
        undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.undoLocationChange();
            }
        });
        undoButton.putClientProperty("JButton.buttonType", buttonStyle);
        undoButton.putClientProperty("JButton.segmentPosition", "first");
        undoButton.setPreferredSize(ICON_SIZE);
        undoButton.setMinimumSize(ICON_SIZE);
        undoButton.setMaximumSize(ICON_SIZE);
        final JButton redo = (JButton)this.add(new JButton(""));
        redo.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.REDO));
        redo.setToolTipText("Redo range change (" + shortcutMod + "+Y)");
        redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.redoLocationChange();
            }
        });
        redo.putClientProperty("JButton.buttonType", buttonStyle);
        redo.putClientProperty("JButton.segmentPosition", "last");
        redo.setPreferredSize(ICON_SIZE);
        redo.setMinimumSize(ICON_SIZE);
        redo.setMaximumSize(ICON_SIZE);
        this.add(NavigationBar.getRigidPadding());
        this.add(NavigationBar.getRigidPadding());
        final JButton zoomInButton = (JButton)this.add(new JButton());
        if (afterGo == null) {
            afterGo = zoomInButton;
        }
        zoomInButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.ZOOMIN));
        zoomInButton.putClientProperty("JButton.buttonType", buttonStyle);
        zoomInButton.putClientProperty("JButton.segmentPosition", "first");
        zoomInButton.setPreferredSize(ICON_SIZE);
        zoomInButton.setMinimumSize(ICON_SIZE);
        zoomInButton.setMaximumSize(ICON_SIZE);
        zoomInButton.setToolTipText("Zoom in (Shift+Up)");
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.zoomIn();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "zoomed"), new NameValuePair("navigation-direction", "in"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        final JButton zoomOut = (JButton)this.add(new JButton(""));
        zoomOut.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.ZOOMOUT));
        zoomOut.setToolTipText("Zoom out (Shift+Down)");
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.zoomOut();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "zoomed"), new NameValuePair("navigation-direction", "out"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        zoomOut.putClientProperty("JButton.buttonType", buttonStyle);
        zoomOut.putClientProperty("JButton.segmentPosition", "last");
        zoomOut.setPreferredSize(ICON_SIZE);
        zoomOut.setMinimumSize(ICON_SIZE);
        zoomOut.setMaximumSize(ICON_SIZE);
        this.add(NavigationBar.getRigidPadding());
        this.add(NavigationBar.getRigidPadding());
        final JButton shiftFarLeft = (JButton)this.add(new JButton());
        shiftFarLeft.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.SHIFT_FARLEFT));
        shiftFarLeft.putClientProperty("JButton.buttonType", buttonStyle);
        shiftFarLeft.putClientProperty("JButton.segmentPosition", "first");
        shiftFarLeft.setToolTipText("Move to the beginning of the genome (Shift+Home)");
        shiftFarLeft.setPreferredSize(ICON_SIZE);
        shiftFarLeft.setMinimumSize(ICON_SIZE);
        shiftFarLeft.setMaximumSize(ICON_SIZE);
        shiftFarLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.shiftRangeFarLeft();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "panned"), new NameValuePair("navigation-direction", "left"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        final JButton shiftLeft = (JButton)this.add(new JButton());
        shiftLeft.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.SHIFT_LEFT));
        shiftLeft.putClientProperty("JButton.buttonType", buttonStyle);
        shiftLeft.putClientProperty("JButton.segmentPosition", "middle");
        shiftLeft.setToolTipText("Move left (Shift+Left)");
        shiftLeft.setPreferredSize(ICON_SIZE);
        shiftLeft.setMinimumSize(ICON_SIZE);
        shiftLeft.setMaximumSize(ICON_SIZE);
        shiftLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.shiftRangeLeft();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "panned"), new NameValuePair("navigation-direction", "left"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        final JButton shiftRight = (JButton)this.add(new JButton());
        shiftRight.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.SHIFT_RIGHT));
        shiftRight.putClientProperty("JButton.buttonType", buttonStyle);
        shiftRight.putClientProperty("JButton.segmentPosition", "middle");
        shiftRight.setToolTipText("Move right (Shift+Right)");
        shiftRight.setPreferredSize(ICON_SIZE);
        shiftRight.setMinimumSize(ICON_SIZE);
        shiftRight.setMaximumSize(ICON_SIZE);
        shiftRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.shiftRangeRight();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "panned"), new NameValuePair("navigation-direction", "right"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        final JButton shiftFarRight = (JButton)this.add(new JButton());
        shiftFarRight.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.SHIFT_FARRIGHT));
        shiftFarRight.putClientProperty("JButton.buttonType", buttonStyle);
        shiftFarRight.putClientProperty("JButton.segmentPosition", "last");
        shiftFarRight.setToolTipText("Move to the end of the genome (Shift+End)");
        shiftFarRight.setPreferredSize(ICON_SIZE);
        shiftFarRight.setMinimumSize(ICON_SIZE);
        shiftFarRight.setMaximumSize(ICON_SIZE);
        shiftFarRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.locationController.shiftRangeFarRight();
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "panned"), new NameValuePair("navigation-direction", "right"), new NameValuePair("navigation-modality", "navbar")});
            }
        });
        this.add(NavigationBar.getRigidPadding());
        this.locationController.addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                NavigationBar.this.updateLocation(event.getReference(), (Range)event.getRange());
            }
        });
        GenomeController.getInstance().addListener(new Listener<GenomeChangedEvent>(){

            @Override
            public void handleEvent(GenomeChangedEvent event) {
                NavigationBar.this.lastPoppedUp = "INVALID";
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                int width = ce.getComponent().getWidth();
                undoButton.setVisible(true);
                redo.setVisible(true);
                zoomInButton.setVisible(true);
                zoomOut.setVisible(true);
                shiftFarLeft.setVisible(true);
                shiftLeft.setVisible(true);
                shiftRight.setVisible(true);
                shiftFarRight.setVisible(true);
                if (width < 1200) {
                    undoButton.setVisible(false);
                    redo.setVisible(false);
                }
                if (width < 1000) {
                    shiftFarLeft.setVisible(false);
                    shiftFarRight.setVisible(false);
                    shiftRight.putClientProperty("JButton.segmentPosition", "last");
                    shiftLeft.putClientProperty("JButton.segmentPosition", "first");
                } else {
                    shiftRight.putClientProperty("JButton.segmentPosition", "middle");
                    shiftLeft.putClientProperty("JButton.segmentPosition", "middle");
                }
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
    }

    private static Component getRigidPadding() {
        return Box.createRigidArea(new Dimension(7, 7));
    }

    private void setRangeFromText(String text) {
        try {
            for (Track t : TrackController.getInstance().getTracks()) {
                List<BookmarkAdapter> marks = t.getDataSource().lookup(text.toLowerCase());
                if (marks == null || marks.size() <= 0) continue;
                this.locationController.setLocation(marks.get(0).getReference(), (Range)marks.get(0).getRange());
                return;
            }
            Bookmark mark = new Bookmark(text);
            this.locationController.setLocation(mark.getReference(), (Range)mark.getRange());
        }
        catch (Exception x) {
            DialogUtils.displayMessage(String.format("Unable to parse \"%s\" as a location.", text));
        }
    }

    private void updateLocation(String ref, Range r) {
        String s = String.format("%s: %,d - %,d", ref, r.getFrom(), r.getTo());
        AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "moved"), new NameValuePair("navigation-range", s)});
        this.locationField.setSelectedItem(s);
        this.lengthLabel.setText(String.format("%,d", r.getLength()));
        this.locationField.requestFocusInWindow();
        this.locationField.getEditor().selectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCombo() {
        String text = (String)this.locationField.getEditor().getItem();
        if (!text.equals(this.lastPoppedUp)) {
            Collection<Object> newItems = new ArrayList();
            if (text.length() > 0) {
                for (Track track : TrackController.getInstance().getTracks()) {
                    List<BookmarkAdapter> marks = track.getDataSource().lookup(text.toLowerCase() + "*");
                    if (marks == null || marks.size() <= 0) continue;
                    for (BookmarkAdapter bm : marks) {
                        newItems.add(String.format("%s (%s)", bm.getAnnotation(), ((Bookmark)bm).getLocationText()));
                    }
                }
            }
            if (newItems.size() > 0 || this.lastPoppedUp != null) {
                if (newItems.size() > 0) {
                    this.lastPoppedUp = text;
                } else {
                    this.lastPoppedUp = null;
                    newItems = GenomeController.getInstance().getGenome().getReferenceNames();
                }
                try {
                    this.currentlyPopulating = true;
                    this.locationField.removeAllItems();
                    for (String string : newItems) {
                        this.locationField.addItem(string);
                    }
                }
                finally {
                    this.currentlyPopulating = false;
                }
            }
        }
    }

    private class ReferenceListRenderer
    extends DefaultListCellRenderer {
        private ReferenceListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String s = (String)value;
            int bracketPos = s.lastIndexOf(40);
            if (bracketPos > 0) {
                c.setText(String.format("<html>%s <small>%s</small></html>", s.substring(0, bracketPos - 1), s.substring(bracketPos)));
            }
            return c;
        }
    }
}

