/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import com.jidesoft.docking.DockableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.DataFormat;
import savant.controller.FrameController;
import savant.view.swing.Frame;

public class DockableFrameFactory {
    private static final Log LOG = LogFactory.getLog(DockableFrameFactory.class);

    public static DockableFrame createFrame(String name, int mode, int side) {
        DockableFrame frame = new DockableFrame(name, null);
        frame.setSlidingAutohide(true);
        frame.setInitMode(mode);
        frame.setInitSide(side);
        frame.add((Component)new JPanel());
        frame.setPreferredSize(new Dimension(400, 400));
        frame.setAutohideWidth(400);
        frame.setAutohideHeight(400);
        return frame;
    }

    public static DockableFrame createGUIPluginFrame(String name) {
        DockableFrame f = DockableFrameFactory.createFrame(name, 2, 2);
        f.setAvailableButtons(28);
        return f;
    }

    public static Frame createTrackFrame(DataFormat df) {
        final Frame frame = new Frame(df);
        frame.setAvailableButtons(21);
        frame.setSlidingAutohide(false);
        frame.setInitMode(4);
        frame.setInitSide(1);
        frame.add(new JPanel());
        frame.setCloseAction(new Action(){
            private boolean isEnabled = true;
            private Map<String, Object> map = new HashMap<String, Object>();

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameController.getInstance().closeFrame(frame, true);
            }

            @Override
            public Object getValue(String key) {
                if (key.equals("Name")) {
                    return "Close";
                }
                return this.map.get(key);
            }

            @Override
            public void putValue(String key, Object value) {
                this.map.put(key, value);
            }

            @Override
            public void setEnabled(boolean b) {
                this.isEnabled = b;
            }

            @Override
            public boolean isEnabled() {
                return this.isEnabled;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        });
        JPanel panel = (JPanel)frame.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add(frame.getFrameLandscape());
        return frame;
    }
}

