/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.format.BAMToCoverage;
import savant.format.FormatEvent;
import savant.format.SavantFileFormatter;
import savant.view.icon.SavantIconFactory;

public class FormatProgressDialog
extends JDialog
implements Listener<FormatEvent> {
    final SavantFileFormatter formatter;
    final boolean toLoadTrack;
    private JLabel destLabel;
    private JProgressBar progressBar;
    private JLabel srcLabel;
    private JLabel statusLabel;

    public FormatProgressDialog(Window parent, SavantFileFormatter sff, boolean toLoad) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.formatter = sff;
        this.toLoadTrack = toLoad;
        this.setIconImage(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.LOGO).getImage());
        this.srcLabel.setText(this.shorten(this.formatter.getInputFile().getPath()));
        this.destLabel.setText(this.shorten(this.formatter.getOutputFile().getPath()));
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.formatter.addListener(this);
            this.formatter.run();
        }
        super.setVisible(flag);
    }

    private void initComponents() {
        JLabel destCaption = new JLabel();
        this.srcLabel = new JLabel();
        JLabel srcCaption = new JLabel();
        this.statusLabel = new JLabel();
        this.progressBar = new JProgressBar();
        JButton cancelButton = new JButton();
        this.destLabel = new JLabel();
        JLabel statusCaption = new JLabel();
        JSeparator jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(0);
        this.setTitle("Formatting ...");
        this.setCursor(new Cursor(3));
        this.setResizable(false);
        destCaption.setText("Destination: ");
        this.srcLabel.setText("filename1");
        srcCaption.setText("Formatting: ");
        this.statusLabel.setText("status ...");
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormatProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.destLabel.setText("filename2");
        statusCaption.setText("Status: ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(destCaption).addComponent(srcCaption)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.srcLabel, -1, 600, Short.MAX_VALUE).addComponent(this.destLabel, -1, 600, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(statusCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel, -1, 644, Short.MAX_VALUE)).addComponent(cancelButton, GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, GroupLayout.Alignment.TRAILING, -1, 699, Short.MAX_VALUE).addComponent(jSeparator1, -1, 699, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(srcCaption).addComponent(this.srcLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(destCaption).addComponent(this.destLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jSeparator1, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(statusCaption).addComponent(this.statusLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelButton).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (DialogUtils.askYesNo("Confirm Cancel", "Are you sure you want to cancel?") == 0) {
            this.formatter.cancel();
            this.dispose();
        }
    }

    @Override
    public void handleEvent(FormatEvent event) {
        switch (event.getType()) {
            case PROGRESS: {
                this.progressBar.setValue((int)(event.getProgress() * 100.0));
                if (event.getSubTask() == null) break;
                this.statusLabel.setText(event.getSubTask());
                break;
            }
            case COMPLETED: {
                this.setVisible(false);
                if (GenomeController.getInstance().isGenomeLoaded()) {
                    if (this.formatter instanceof BAMToCoverage) {
                        DialogUtils.displayMessage("Format Successful", String.format("<HTML>Format successful.<BR>Coverage will be available the next time you open <i>%s</i>.</HTML>", this.formatter.getInputFile().getName()));
                        break;
                    }
                    if (!this.toLoadTrack && DialogUtils.askYesNo("Format Successful", "Format successful. Open track now?") != 0) break;
                    try {
                        FrameController.getInstance().addTrackFromPath(this.formatter.getOutputFile().getAbsolutePath(), null, null);
                    }
                    catch (Exception exception) {}
                    break;
                }
                DialogUtils.displayMessage("Format Successful", "<HTML>Format successful. <BR>A genome must be loaded before you can open this track.</HTML>");
                break;
            }
            case FAILED: {
                this.setVisible(false);
                SavantFileFormatter.reportFormattingError(event.getError(), this.formatter.getInputFile());
            }
        }
    }

    private String shorten(String path) {
        int maxLen = 80;
        if (path.length() > maxLen) {
            String parent;
            String file = new File(path).getName();
            while ((parent = new File(path).getParent()) != null && (path = parent).length() > 0 && path.length() + 2 + file.length() > maxLen) {
            }
            return path + "\u2026" + File.separator + file;
        }
        return path;
    }
}

