/*
 * Decompiled with CFR 0.152.
 */
package savant.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import savant.view.icon.SavantIconFactory;

public class ProgressPanel
extends JPanel {
    private JButton cancelButton;
    private JLabel message;
    private JProgressBar bar;

    public ProgressPanel(ActionListener cancellationListener) {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(12, 0, 3, 0);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        this.bar = new JProgressBar();
        this.bar.setIndeterminate(true);
        Dimension prefSize = this.bar.getPreferredSize();
        prefSize.width = 240;
        this.bar.setPreferredSize(prefSize);
        this.add((Component)this.bar, gbc);
        if (cancellationListener != null) {
            this.cancelButton = new JButton(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.CLOSE_LIGHT));
            this.cancelButton.setContentAreaFilled(false);
            this.cancelButton.setBorderPainted(false);
            this.cancelButton.setRolloverIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.CLOSE_DARK));
            this.cancelButton.addActionListener(cancellationListener);
            gbc.fill = 0;
            gbc.gridwidth = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.cancelButton, gbc);
        }
        this.message = new JLabel();
        gbc.insets = new Insets(3, 0, 3, 0);
        gbc.fill = 2;
        this.add((Component)this.message, gbc);
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
    }

    public void setFraction(double fract) {
        if (fract < 0.0) {
            this.bar.setIndeterminate(true);
        } else {
            this.bar.setIndeterminate(false);
            this.bar.setValue((int)Math.round(fract * 100.0));
        }
    }
}

