/*
 * Decompiled with CFR 0.152.
 */
package savant.util.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.TrackAdapter;
import savant.util.DownloadEvent;
import savant.util.MiscUtils;
import savant.util.export.TrackExporter;
import savant.view.tracks.SequenceTrack;

public class FastaExporter
extends TrackExporter {
    private static final int LINE_SIZE = 50;
    private static final int PROGRESS_INTERVAL = 100000;
    FastaOutputStream fastaOutput;
    Map<String, Long> refOffsets = new HashMap<String, Long>();

    FastaExporter(TrackAdapter t, File f) throws IOException {
        super(t, f);
        this.fastaOutput = new FastaOutputStream(new FileOutputStream(this.destFile));
    }

    @Override
    void close() throws IOException {
        if (this.fastaOutput != null) {
            this.fastaOutput.close();
        }
    }

    @Override
    void exportRange(String ref, RangeAdapter r) throws IOException, InterruptedException {
        byte[] seq;
        this.fastaOutput.write(62);
        this.fastaOutput.write(ref.getBytes());
        this.fastaOutput.write(10);
        this.refOffsets.put(MiscUtils.homogenizeSequence(ref), this.fastaOutput.numWritten);
        int linePos = 0;
        if (r.getFrom() > 1) {
            for (int i = 1; i < r.getFrom(); ++i) {
                this.fastaOutput.write(78);
                if (++linePos != 50) continue;
                this.fastaOutput.write(10);
                linePos = 0;
            }
            this.basesSoFar += (long)(r.getFrom() - 1);
            this.fireEvent(new DownloadEvent((double)this.basesSoFar / (double)this.totalBases));
        }
        if ((seq = ((SequenceTrack)this.track).getSequence(ref, r)) == null) {
            seq = new byte[r.getLength()];
            for (int i = 0; i < seq.length; ++i) {
                seq[i] = 78;
            }
        }
        int j = 0;
        if (linePos > 0) {
            int numBytes = Math.min(seq.length, 50 - linePos);
            this.fastaOutput.write(seq, 0, numBytes);
            this.fastaOutput.write(10);
            j = numBytes;
            linePos = 0;
        }
        long lastProgress = this.basesSoFar;
        while (j + 50 < seq.length) {
            this.fastaOutput.write(seq, j, 50);
            this.fastaOutput.write(10);
            j += 50;
            this.basesSoFar += 50L;
            if (this.basesSoFar - lastProgress <= 100000L) continue;
            lastProgress = this.basesSoFar;
            this.fireEvent(new DownloadEvent((double)this.basesSoFar / (double)this.totalBases));
        }
        this.fastaOutput.write(seq, j, seq.length - j);
        this.basesSoFar += (long)(seq.length - j);
        this.fireEvent(new DownloadEvent((double)this.basesSoFar / (double)this.totalBases));
    }

    public long appendFiller(SAMSequenceDictionary samDict) throws IOException {
        long fillerLength = 0L;
        for (SAMSequenceRecord samRec : samDict.getSequences()) {
            if (this.refOffsets.containsKey(samRec.getSequenceName())) continue;
            fillerLength = Math.max(fillerLength, (long)samRec.getSequenceLength());
        }
        if (fillerLength > 0L) {
            BufferedOutputStream fillerOutput = new BufferedOutputStream(new FileOutputStream(this.destFile, true));
            int j = 0;
            while ((long)j < fillerLength) {
                for (int k = 0; k < 50; ++k) {
                    ((OutputStream)fillerOutput).write(78);
                }
                ((OutputStream)fillerOutput).write(10);
                j += 50;
            }
            ((OutputStream)fillerOutput).close();
        }
        return this.fastaOutput.numWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFakeIndex(SAMSequenceDictionary samDict, boolean fillerNeeded) throws IOException {
        long fillerStart = 0L;
        if (fillerNeeded) {
            fillerStart = this.appendFiller(samDict);
        }
        OutputStream faiOutput = null;
        try {
            faiOutput = new FileOutputStream(this.destFile.getAbsolutePath() + ".fai");
            for (SAMSequenceRecord samRec : samDict.getSequences()) {
                String samRef = samRec.getSequenceName();
                long offset = fillerStart;
                if (this.refOffsets.containsKey(samRef)) {
                    offset = this.refOffsets.get(samRef);
                }
                faiOutput.write(String.format("%s\t%d\t%d\t%d\t%d\n", samRef, samRec.getSequenceLength(), offset, 50, 51).getBytes());
            }
        }
        finally {
            if (faiOutput != null) {
                faiOutput.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFakeSequenceDictionary(SAMSequenceDictionary samDict) throws IOException {
        OutputStream dictOutput = null;
        try {
            String fastaPath = this.destFile.getAbsolutePath();
            String s = fastaPath.replaceFirst("\\.(fa)|(fasta)$", ".dict");
            dictOutput = new FileOutputStream(s);
            dictOutput.write("@HD\tVN:1.0\tSO:unsorted\n".getBytes());
            for (SAMSequenceRecord samRec : samDict.getSequences()) {
                String samRef = samRec.getSequenceName();
                dictOutput.write(String.format("@SQ\tSN:%s\tLN:%d\tUR:file:%s\tM5:00000000000000000000000000000000\n", samRef, samRec.getSequenceLength(), fastaPath).getBytes());
            }
        }
        finally {
            if (dictOutput != null) {
                dictOutput.close();
            }
        }
    }

    private static class FastaOutputStream
    extends BufferedOutputStream {
        long numWritten = 0L;

        FastaOutputStream(OutputStream os) {
            super(os);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            ++this.numWritten;
            super.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.numWritten += (long)len;
            super.write(b, off, len);
        }
    }
}

