/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.Serializable;
import savant.api.adapter.RangeAdapter;
import savant.util.MiscUtils;

public final class Range
implements RangeAdapter,
Serializable {
    static final long serialVersionUID = 2690664822084781217L;
    private long from;
    private long to;

    public Range(int from, int to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public int getFrom() {
        return (int)this.from;
    }

    @Override
    public int getTo() {
        return (int)this.to;
    }

    @Override
    public int getLength() {
        return (int)(this.to - this.from) + 1;
    }

    @Override
    @Deprecated
    public int getFromAsInt() {
        return (int)this.from;
    }

    @Override
    @Deprecated
    public int getToAsInt() {
        return (int)this.to;
    }

    @Override
    @Deprecated
    public int getLengthAsInt() {
        return (int)(this.to - this.from) + 1;
    }

    public String toString() {
        return MiscUtils.numToString(this.from) + "-" + MiscUtils.numToString(this.to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.from != range.from) {
            return false;
        }
        return this.to == range.to;
    }

    public int hashCode() {
        int result = (int)this.from;
        result = 31 * result + (int)this.to;
        return result;
    }
}

