/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.EnumMap;
import java.util.Map;
import savant.api.data.Strand;
import savant.api.data.VariantType;

public final class Pileup {
    private int position;
    private Map<VariantType, Coverage> coverage = new EnumMap<VariantType, Coverage>(VariantType.class);

    public Pileup(int position) {
        this.position = position;
        this.clearVariantType(VariantType.SNP_A);
        this.clearVariantType(VariantType.SNP_C);
        this.clearVariantType(VariantType.SNP_G);
        this.clearVariantType(VariantType.SNP_T);
        this.clearVariantType(VariantType.DELETION);
        this.clearVariantType(VariantType.INSERTION);
        this.clearVariantType(VariantType.OTHER);
    }

    public int getPosition() {
        return this.position;
    }

    public void pileOn(VariantType n, double quality, Strand strand) {
        if (n != VariantType.NONE) {
            this.coverage.get((Object)n).pileOn(quality, strand);
        }
    }

    public VariantType getLargestVariantType(VariantType notThis) {
        VariantType[] values = new VariantType[]{VariantType.SNP_A, VariantType.SNP_C, VariantType.SNP_G, VariantType.SNP_T, VariantType.DELETION, VariantType.INSERTION, VariantType.OTHER};
        VariantType snpNuc = null;
        for (VariantType n : values) {
            if (n == notThis || this.getCoverage(n, null) <= 0 || snpNuc != null && this.getCoverage(n, null) <= this.getCoverage(snpNuc, null)) continue;
            snpNuc = n;
        }
        return snpNuc;
    }

    public void clearVariantType(VariantType n) {
        this.coverage.put(n, new Coverage());
    }

    public int getCoverage(VariantType n, Strand strand) {
        Coverage cov = this.coverage.get((Object)n);
        if (strand == Strand.FORWARD) {
            return cov.forwardCount;
        }
        if (strand == Strand.REVERSE) {
            return cov.reverseCount;
        }
        return cov.count;
    }

    public int getTotalCoverage(Strand strand) {
        int total = 0;
        if (strand == Strand.FORWARD) {
            for (Coverage cov : this.coverage.values()) {
                total += cov.forwardCount;
            }
        } else if (strand == Strand.REVERSE) {
            for (Coverage cov : this.coverage.values()) {
                total += cov.reverseCount;
            }
        } else {
            for (Coverage cov : this.coverage.values()) {
                total += cov.count;
            }
        }
        return total;
    }

    public double getAverageQuality(VariantType n, Strand strand) {
        Coverage cov = this.coverage.get((Object)n);
        if (strand == Strand.FORWARD) {
            return cov.forwardSum / (double)cov.forwardCount;
        }
        if (strand == Strand.REVERSE) {
            return cov.reverseSum / (double)cov.reverseCount;
        }
        return cov.sum / (double)cov.count;
    }

    private class Coverage {
        int count = 0;
        int forwardCount = 0;
        int reverseCount = 0;
        double sum = 0.0;
        double forwardSum = 0.0;
        double reverseSum = 0.0;

        private Coverage() {
        }

        void pileOn(double quality, Strand strand) {
            ++this.count;
            this.sum += quality;
            if (strand == Strand.FORWARD) {
                ++this.forwardCount;
                this.forwardSum += quality;
            } else if (strand == Strand.REVERSE) {
                ++this.reverseCount;
                this.reverseSum += quality;
            }
        }
    }
}

