/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public abstract class Hoverer
extends MouseAdapter
implements ActionListener {
    private static final double HOVER_THRESHOLD = 2.0;
    private static final int HOVER_INTERVAL = 1000;
    protected Point hoverPos = null;
    private final Timer timer = new Timer(1000, this);

    public Hoverer() {
        this.timer.setRepeats(false);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Point pt = evt.getPoint();
        if (this.hoverPos != null) {
            if (!this.isHoverable(pt)) {
                this.hoverPos = pt;
                this.timer.restart();
            }
        } else {
            this.hoverPos = pt;
            this.timer.start();
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.timer.stop();
        this.hoverPos = null;
    }

    public boolean isHoverable(Point pt) {
        if (this.hoverPos != null) {
            return pt.distanceSq(this.hoverPos) <= 2.0;
        }
        return false;
    }
}

