/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import savant.util.MiscUtils;

public class FileExtensionFilter
extends FileFilter
implements FilenameFilter {
    private String extension;
    private String description;

    public FileExtensionFilter(String desc, String ext) {
        this.description = String.format("%s (*.%s)", desc, ext);
        this.extension = ext;
    }

    public FileExtensionFilter(String ext) {
        this(ext.toUpperCase() + " files", ext);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = MiscUtils.getExtension(f.getAbsolutePath());
        return this.extension.equals(ext);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith("." + this.extension);
    }
}

