/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.util.RemoteFileCache;

public class CachedSeekableStream
extends SeekableStream {
    private static final Log LOG = LogFactory.getLog(CachedSeekableStream.class);
    private final SeekableStream wrappedStream;
    private final int bufferSize;
    private final URI uri;
    private File cacheFile = null;
    private int numBlocks = 0;
    private RandomAccessFile cache = null;
    private BufferedInputStream bufferedStream;
    private int positionInBuf = 0;
    private long positionInFile = 0L;

    public CachedSeekableStream(SeekableStream seekable, int bufSize, URI uri) {
        this.wrappedStream = seekable;
        this.bufferSize = bufSize;
        this.uri = uri;
        this.bufferedStream = new BufferedInputStream((InputStream)this.wrappedStream, this.bufferSize);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int posInByteArray = offset;
        int bytesRead = 0;
        while (length > 0) {
            int canRead = this.bufferSize - this.positionInBuf;
            if (canRead == 0) {
                this.seek(this.positionInFile);
                canRead = this.bufferSize - this.positionInBuf;
            }
            int toRead = Math.min(canRead, length);
            byte[] buff1 = new byte[toRead];
            int bytesReadThisTime = this.bufferedStream.read(buff1, 0, toRead);
            System.arraycopy(buff1, 0, buffer, posInByteArray, toRead);
            this.positionInFile += (long)bytesReadThisTime;
            posInByteArray += toRead;
            length -= toRead;
            bytesRead += bytesReadThisTime;
            this.positionInBuf += bytesReadThisTime;
        }
        return bytesRead;
    }

    private void cachedSeek(int blockOffset, int positionOffset) throws IOException {
        long actualOffset = (long)this.numBlocks * 4L + ((long)blockOffset - 1L) * (long)this.bufferSize;
        FileInputStream cacheStream = new FileInputStream(this.cacheFile);
        cacheStream.skip(actualOffset);
        this.bufferedStream.close();
        this.bufferedStream = new BufferedInputStream(cacheStream, this.bufferSize);
        this.bufferedStream.skip(positionOffset);
        this.positionInBuf = positionOffset;
    }

    public synchronized void seek(long pos) throws IOException {
        this.positionInFile = pos;
        int block = (int)(pos / (long)this.bufferSize);
        this.openCache();
        this.cache.seek(block * 4);
        int offset = this.cache.readInt();
        if (offset != 0) {
            int positionOffset = (int)(pos % (long)this.bufferSize);
            this.cachedSeek(offset, positionOffset);
            this.closeCache();
        } else {
            this.positionInFile = pos - pos % (long)this.bufferSize;
            this.wrappedStream.seek(this.positionInFile);
            this.bufferedStream.close();
            this.bufferedStream = new BufferedInputStream((InputStream)this.wrappedStream, this.bufferSize);
            byte[] b = new byte[this.bufferSize];
            int numRead = this.bufferedStream.read(b, 0, this.bufferSize);
            int storeOffset = (int)((this.cache.length() - (long)(this.numBlocks * 4)) / (long)this.bufferSize) + 1;
            long actualOffset = this.cache.length();
            this.cache.seek(block * 4);
            this.cache.writeInt(storeOffset);
            this.cache.seek(actualOffset);
            this.cache.write(b, 0, this.bufferSize);
            this.positionInBuf = 0;
            this.closeCache();
            this.seek(pos);
        }
    }

    public long length() {
        return this.wrappedStream.length();
    }

    public String getSource() {
        return this.wrappedStream.getSource();
    }

    public void close() throws IOException {
        this.wrappedStream.close();
    }

    public boolean eof() throws IOException {
        return this.positionInFile >= this.wrappedStream.length();
    }

    public int read() throws IOException {
        byte[] sillyBuf = new byte[1];
        this.read(sillyBuf, 0, 1);
        return sillyBuf[0];
    }

    private void openCache() throws IOException {
        if (this.cacheFile == null || !this.cacheFile.exists()) {
            this.initCache();
        }
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private void closeCache() throws IOException {
        this.cache.close();
        this.cache = null;
    }

    private void initCache() throws IOException {
        this.cacheFile = RemoteFileCache.getCacheFile(this.uri.toURL(), this.getSource(), this.bufferSize, this.length());
        this.numBlocks = (int)Math.ceil((double)this.length() / (double)this.bufferSize);
        RandomAccessFile raf = new RandomAccessFile(this.cacheFile, "rw");
        for (int i = 0; i < this.numBlocks; ++i) {
            raf.write(0);
            raf.write(0);
            raf.write(0);
            raf.write(0);
        }
        raf.close();
    }
}

