/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.settings.DirectorySettings;
import savant.util.ColourKey;

public class PersistentSettings
extends Properties {
    protected static final Log LOG = LogFactory.getLog(PersistentSettings.class);
    private static final String SETTINGS_FILE = "savant.settings";
    private static PersistentSettings instance = null;

    public static PersistentSettings getInstance() {
        if (instance == null) {
            instance = new PersistentSettings();
            instance.load();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        FileInputStream fis = null;
        try {
            File settingsFile = new File(DirectorySettings.getSavantDirectory(), SETTINGS_FILE);
            if (settingsFile.exists()) {
                fis = new FileInputStream(settingsFile);
                this.load(fis);
            }
        }
        catch (Exception x) {
            LOG.error((Object)"Unable to load savant.settings", (Throwable)x);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void store() throws IOException {
        super.store(new FileOutputStream(new File(DirectorySettings.getSavantDirectory(), SETTINGS_FILE)), "Savant settings");
    }

    public Color getColour(String key, Color dflt) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                value = value.toUpperCase();
                int a = 255;
                if (value.length() >= 6) {
                    int r = Integer.parseInt(value.substring(0, 2), 16);
                    int g = Integer.parseInt(value.substring(2, 4), 16);
                    int b = Integer.parseInt(value.substring(4, 6), 16);
                    if (value.length() == 8) {
                        a = Integer.parseInt(value.substring(6, 8), 16);
                    }
                    return new Color(r, g, b, a);
                }
                LOG.warn((Object)String.format("Couldn't parse \"%s\" as a colour.", value));
            }
            catch (NumberFormatException nfx) {
                LOG.warn((Object)String.format("Couldn't parse \"%s\" as a colour.", value), (Throwable)nfx);
            }
        }
        return dflt;
    }

    public Color getColor(ColourKey key, Color dflt) {
        return this.getColour(key.toString(), dflt);
    }

    public void setColour(String key, Color value) {
        this.setProperty(key, String.format("%02X%02X%02X%02X", value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha()));
    }

    public void setColor(ColourKey key, Color value) {
        this.setColour(key.toString(), value);
    }

    public boolean getBoolean(String key, boolean dflt) {
        String value = this.getProperty(key);
        return value != null ? value.toLowerCase().equals("true") : dflt;
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public File getFile(String key) {
        String value = this.getProperty(key);
        return value != null ? new File(value) : null;
    }

    public void setFile(String key, File value) {
        this.setProperty(key, value.getAbsolutePath());
    }

    public int getInt(String key, int dflt) {
        String value = this.getProperty(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return dflt;
        }
    }

    public void setInt(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public String getString(String key) {
        String value = this.getProperty(key);
        return value;
    }

    public void setString(String key, String value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.setProperty(key, value);
        }
    }
}

