/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import javax.swing.JLabel;
import savant.api.data.Strand;
import savant.data.types.PileupRecord;
import savant.selection.PopupPanel;
import savant.util.DrawingMode;

public class PileupPopup
extends PopupPanel {
    PileupPopup() {
        this.end = -1;
        this.start = -1;
    }

    @Override
    protected void initInfo() {
        PileupRecord rec = (PileupRecord)this.record;
        this.add(new JLabel("Position: " + rec.getPosition()));
        if (this.mode == DrawingMode.STRAND_SNP) {
            this.add(new JLabel("Strand +"));
            this.addStrand(rec, Strand.FORWARD, "   ");
            this.add(new JLabel("Strand -"));
            this.addStrand(rec, Strand.REVERSE, "   ");
        } else {
            this.addStrand(rec, null, "");
        }
    }

    @Override
    protected void initStandardButtons() {
    }

    private void addStrand(PileupRecord rec, Strand strand, String indent) {
        int[] coverage = rec.getCoverage(strand);
        double[] percentage = rec.getPercentage(strand);
        double[] quality = rec.getAverageQuality(strand);
        for (int i = 0; i < coverage.length; ++i) {
            if (coverage[i] <= 0) continue;
            this.add(new JLabel(String.format("%s%s: %d (%.1f%%) (avg. BQ %.1f)", indent, PileupRecord.NUCLEOTIDE_NAMES[i], coverage[i], percentage[i], quality[i])));
        }
    }
}

