/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin.builtin;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.DialogUtils;
import savant.settings.BrowserSettings;
import savant.util.NetworkUtils;

public class AddSAFEGroup
extends JDialog {
    private static final Log LOG = LogFactory.getLog(AddSAFEGroup.class);
    private String username;
    private String password;
    private JTextArea descriptionField;
    private JScrollPane jScrollPane1;
    private JTextField nameField;

    public AddSAFEGroup(Window parent, String username, String password) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.username = username;
        this.password = password;
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        JLabel nameCaption = new JLabel();
        this.nameField = new JTextField();
        JLabel descriptionCaption = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionField = new JTextArea();
        JButton cancelButton = new JButton();
        JButton createButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create SAFE Group");
        nameCaption.setText("Name:");
        descriptionCaption.setText("Description:");
        this.descriptionField.setColumns(20);
        this.descriptionField.setRows(5);
        this.descriptionField.setText("Enter a group description here.");
        this.jScrollPane1.setViewportView(this.descriptionField);
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSAFEGroup.this.cancelButtonActionPerformed(evt);
            }
        });
        createButton.setText("Create Group");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSAFEGroup.this.createButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addComponent(this.nameField, -1, 376, Short.MAX_VALUE).addComponent(nameCaption).addComponent(descriptionCaption).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(createButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(nameCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(descriptionCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cancelButton).addComponent(createButton)).addContainerGap()));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        try {
            String n = this.nameField.getText();
            String d = this.descriptionField.getText();
            String result = NetworkUtils.downloadFile(new URL(BrowserSettings.SAFE_URL + "?" + "type=addgroup" + "&username=" + URLEncoder.encode(this.username, "UTF-8") + "&password=" + URLEncoder.encode(this.password, "UTF-8") + "&name=" + URLEncoder.encode(n, "UTF-8") + "&description=" + URLEncoder.encode(d, "UTF-8")));
            LOG.info((Object)result);
            if (result.contains("Error")) {
                DialogUtils.displayError(result);
            } else {
                DialogUtils.displayMessage("Welcome to the group \"" + n + "\".");
            }
            this.dispose();
        }
        catch (IOException x) {
            LOG.error((Object)"Unable to download SAFE index.", (Throwable)x);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

