/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;
import org.broad.tabix.TabixWriter;
import org.broad.tribble.readers.AsciiLineReader;
import savant.file.FileType;
import savant.format.SavantFileFormatter;
import savant.format.SavantFileFormattingException;
import savant.util.ColumnMapping;

public class TabixFormatter
extends SavantFileFormatter {
    private String header;
    private ColumnMapping mapping;
    private TabixWriter.Conf conf;
    private List<String> dictionary = new ArrayList<String>();
    private boolean needsTabHack = false;
    private long fileLength;
    private long bytesWritten;
    private long bytesRead;
    private int sortProgress;

    public TabixFormatter(File inFile, File outFile, FileType inputFileType, boolean needsTabs) throws IOException, SavantFileFormattingException {
        super(inFile, outFile);
        this.needsTabHack = needsTabs;
        int flags = 0;
        switch (inputFileType) {
            case INTERVAL_GENERIC: {
                this.header = "chrom\tstart\tend\tname";
                break;
            }
            case INTERVAL_BED: {
                flags = 65536;
                this.header = "chrom\tstart\tend\tname\tscore\tstrand\tthickStart\tthickEnd\titemRgb\tblockCount\tblockSizes\tblockStarts";
                break;
            }
            case INTERVAL_BED1: {
                flags = 65536;
                this.header = "bin\tchrom\tstart\tend\tname\tscore\tstrand\tthickStart\tthickEnd\titemRgb\tblockCount\tblockSizes\tblockStarts";
                break;
            }
            case INTERVAL_GFF: {
                this.header = "seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tgroup";
                break;
            }
            case INTERVAL_GTF: {
                this.header = "seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tattributes";
                break;
            }
            case INTERVAL_KNOWNGENE: {
                flags = 65536;
                this.header = "name\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tproteinID\talignID";
                break;
            }
            case INTERVAL_REFGENE: {
                flags = 65536;
                this.header = "bin\tname\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tid\tname2\tcdsStartStat\tcdsEndStat\texonFrames";
                break;
            }
            case INTERVAL_PSL: {
                flags = 65536;
                this.header = "matches\tmisMatches\trepMatches\tnCount\tqNumInsert\tqBaseInsert\ttNumInsert\ttBaseInsert\tstrand\tqName\tqSize\tqStart\tqEnd\ttName\ttSize\ttStart\ttEnd\tblockCount\tblockSizes\tqStarts\ttStarts";
                break;
            }
            case INTERVAL_VCF: {
                flags = 2;
                this.readHeaderLine();
                break;
            }
            case INTERVAL_UNKNOWN: {
                this.readHeaderLine();
            }
        }
        this.mapping = ColumnMapping.inferMapping(this.header, (flags & 0x10000) == 0);
        this.conf = this.mapping.getTabixConf(flags);
        if (this.mapping.chrom < 0 || this.mapping.start < 0) {
            throw new SavantFileFormattingException("Unable to determine columns.  Does this file have a proper header line?");
        }
    }

    private void readHeaderLine() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInput()));
        String line = reader.readLine();
        while (line.charAt(0) == '#') {
            this.header = line;
            line = reader.readLine();
        }
        reader.close();
        if (this.header != null) {
            while (this.header.length() > 0 && this.header.charAt(0) == '#') {
                this.header = this.header.substring(1);
            }
        }
    }

    @Override
    public void format() throws InterruptedException, IOException {
        try {
            String line;
            this.setProgress(0.0, "Sorting input file...");
            File sortedFile = File.createTempFile("savant", ".sorted");
            new TabixSorter(this.inFile, sortedFile).run();
            this.setProgress(0.25, "Compressing text file...");
            AsciiLineReader input = new AsciiLineReader(new FileInputStream(sortedFile));
            PrintWriter output = new PrintWriter((OutputStream)new BlockCompressedOutputStream(this.outFile));
            while ((line = input.readLine()) != null) {
                String name2;
                String name;
                if (line.isEmpty()) continue;
                output.print(line + "\n");
                if (this.mapping.name < 0 && this.mapping.name2 < 0 || line.startsWith("#")) continue;
                String[] columns = line.split("\\t");
                String chrom = columns[this.mapping.chrom];
                int start = Integer.valueOf(columns[this.mapping.start]);
                int len = 1;
                if (this.mapping.end >= 0) {
                    len = Integer.valueOf(columns[this.mapping.end]) - start;
                }
                String value = chrom + ":" + start + "+" + len;
                if (this.mapping.name >= 0 && (name = columns[this.mapping.name]) != null && name.length() > 0) {
                    this.dictionary.add(name + "\t" + value);
                }
                if (this.mapping.name2 < 0 || (name2 = columns[this.mapping.name2]) == null || name2.length() <= 0) continue;
                this.dictionary.add(name2 + "\t" + value);
            }
            output.close();
            input.close();
            this.setProgress(0.5, "Creating index file...");
            TabixWriter writer = new TabixWriter(this.outFile, this.conf);
            writer.createIndex(this.outFile);
            if (this.dictionary.size() > 0) {
                this.setProgress(0.75, "Creating dictionary file...");
                output = new PrintWriter((OutputStream)new BlockCompressedOutputStream(this.outFile.getAbsolutePath() + ".dict"));
                Collections.sort(this.dictionary);
                for (String l : this.dictionary) {
                    output.print(l + "\n");
                }
                output.close();
            }
            this.setProgress(1.0, null);
        }
        catch (Exception x) {
            throw new IOException(x);
        }
    }

    private void updateSortProgress() {
        int newProg = (int)((double)(this.bytesRead + this.bytesWritten) * 12.5 / (double)this.fileLength);
        if (newProg != this.sortProgress) {
            this.sortProgress = newProg;
            this.setProgress((double)this.sortProgress * 0.01, null);
        }
    }

    public InputStream getInput() throws FileNotFoundException {
        return this.needsTabHack ? new TabFixingInputStream(this.inFile) : new ProgressiveInputStream(this.inFile);
    }

    private class ProgressiveWriter
    extends FileWriter {
        ProgressiveWriter(File f) throws IOException {
            super(f);
            TabixFormatter.this.bytesWritten = 0L;
        }

        void write(char c) throws IOException {
            TabixFormatter.this.bytesWritten++;
            super.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            TabixFormatter.this.bytesWritten += len;
            TabixFormatter.this.updateSortProgress();
            super.write(cbuf, off, len);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            TabixFormatter.this.bytesWritten += len;
            TabixFormatter.this.updateSortProgress();
            super.write(str, off, len);
        }
    }

    private class TabFixingInputStream
    extends ProgressiveInputStream {
        private boolean trailingSpace;
        private byte[] tempBuf;

        private TabFixingInputStream(File f) throws FileNotFoundException {
            super(f);
            this.tempBuf = new byte[0];
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.tempBuf.length < b.length) {
                this.tempBuf = new byte[b.length];
            }
            int n = super.read(this.tempBuf, off, len);
            int j = off;
            for (int i = 0; i < n; ++i) {
                byte c = this.tempBuf[i + off];
                if (c == 32) {
                    if (this.trailingSpace) continue;
                    this.trailingSpace = true;
                    b[j++] = 9;
                    continue;
                }
                this.trailingSpace = false;
                b[j++] = c;
            }
            SavantFileFormatter.LOG.info((Object)("read(" + b.length + ", " + off + ", " + len + ") returning " + (j - off) + " instead of " + n));
            return j - off;
        }
    }

    private class ProgressiveInputStream
    extends FilterInputStream {
        private ProgressiveInputStream(File f) throws FileNotFoundException {
            super(new FileInputStream(f));
            TabixFormatter.this.fileLength = f.length();
            TabixFormatter.this.bytesRead = 0L;
        }

        @Override
        public int read() throws IOException {
            TabixFormatter.this.bytesRead++;
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            TabixFormatter.this.bytesRead += n;
            TabixFormatter.this.updateSortProgress();
            return n;
        }
    }

    private class TabixSorter
    extends Sorter {
        TabixSorter(File inFile, File sortedFile) {
            super(inFile, sortedFile);
        }

        @Override
        public Parser getParser() throws IOException {
            return new Parser(((TabixFormatter)TabixFormatter.this).mapping.chrom, ((TabixFormatter)TabixFormatter.this).mapping.start);
        }

        @Override
        public String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
            String nextLine = reader.readLine();
            while (nextLine.startsWith("#")) {
                writer.print(nextLine + "\n");
                nextLine = reader.readLine();
            }
            int numColumns = nextLine.split("\\t").length;
            String[] headerColumns = TabixFormatter.this.header.split("\\t");
            if (headerColumns.length > numColumns) {
                TabixFormatter.this.header = headerColumns[0];
                for (int i = 1; i < numColumns; ++i) {
                    TabixFormatter.this.header = TabixFormatter.this.header + ("\t" + headerColumns[i]);
                }
            }
            writer.print("#" + TabixFormatter.this.header + "\n");
            TabixFormatter.this.mapping = ColumnMapping.inferMapping(TabixFormatter.this.header, ((TabixFormatter)TabixFormatter.this).mapping.oneBased);
            return nextLine;
        }

        @Override
        public InputStream getInput() throws FileNotFoundException {
            return TabixFormatter.this.getInput();
        }

        @Override
        public PrintWriter getOutput() throws IOException {
            return new PrintWriter(new BufferedWriter(new ProgressiveWriter(this.outputFile)));
        }
    }
}

