/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.util.ArrayList;
import java.util.List;
import savant.util.Range;

public class IntervalTreeNode
implements Comparable {
    public int size;
    public int subtreeSize;
    public Range range;
    public long startByte;
    public int index;
    public List<IntervalTreeNode> children;
    public IntervalTreeNode parent;

    public IntervalTreeNode(Range r, int index, IntervalTreeNode parent) {
        this.range = r;
        this.size = 0;
        this.subtreeSize = 0;
        this.startByte = -1L;
        this.children = new ArrayList<IntervalTreeNode>();
        this.parent = parent;
        this.index = index;
    }

    public IntervalTreeNode(Range r, int index) {
        this(r, index, null);
    }

    public IntervalTreeNode(Range r, IntervalTreeNode parent) {
        this(r, -1, parent);
    }

    public String toString() {
        String s = "#" + this.index + "(" + this.range.toString() + ")";
        return s;
    }

    boolean isLeaf() {
        for (IntervalTreeNode c : this.children) {
            if (c == null) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        IntervalTreeNode n = (IntervalTreeNode)o;
        if (this.index < n.index) {
            return -1;
        }
        if (this.index == n.index) {
            return 0;
        }
        return 1;
    }
}

