/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.util.ArrayList;
import java.util.List;
import savant.format.IntervalTreeNode;
import savant.util.Range;

public class IntervalSearchTree {
    private IntervalTreeNode root;
    private List<IntervalTreeNode> nodes;
    private int arity = 5;
    private int minBinSize = 10000;
    private int numcreated = 0;

    public IntervalSearchTree(Range r) {
        this.nodes = new ArrayList<IntervalTreeNode>();
        this.root = this.createNode(r, null);
    }

    public IntervalSearchTree(List<IntervalTreeNode> nodes) {
        this(nodes, 0);
    }

    public IntervalSearchTree(List<IntervalTreeNode> nodes, int indexOfRoot) {
        this(nodes, nodes.get(indexOfRoot));
    }

    public IntervalSearchTree(List<IntervalTreeNode> nodes, IntervalTreeNode root) {
        this.nodes = nodes;
        this.root = root;
    }

    public IntervalTreeNode insert(Range r) {
        return this.insertAtNode(r, this.root);
    }

    public IntervalTreeNode insertAtNode(Range r, IntervalTreeNode n) {
        Range childRange;
        ++n.subtreeSize;
        for (IntervalTreeNode c : n.children) {
            if (!this.contains(c.range, r)) continue;
            return this.insertAtNode(r, c);
        }
        if (n.range.getLength() > this.minBinSize && (childRange = this.getRangeOfContainingChild(n, r)) != null) {
            IntervalTreeNode child = this.createNode(childRange, n);
            n.children.add(child);
            return this.insertAtNode(r, child);
        }
        ++n.size;
        return n;
    }

    private IntervalTreeNode createNode(Range r, IntervalTreeNode p) {
        return this.createNode(r, this.numcreated, p);
    }

    private IntervalTreeNode createNode(Range r, int index, IntervalTreeNode parent) {
        IntervalTreeNode n = new IntervalTreeNode(r, index, parent);
        this.nodes.add(n);
        ++this.numcreated;
        return n;
    }

    public IntervalTreeNode getRoot() {
        return this.root;
    }

    public int getNumNodes() {
        int nonnullnodes = 0;
        for (IntervalTreeNode n : this.nodes) {
            if (n == null) continue;
            ++nonnullnodes;
        }
        return nonnullnodes;
    }

    public int getArity() {
        return this.arity;
    }

    private boolean intervalFitsInNode(IntervalTreeNode node, Range r) {
        return node.range.getFrom() <= r.getFrom() && node.range.getTo() >= r.getTo();
    }

    private boolean contains(Range container, Range contained) {
        return container.getFrom() <= contained.getFrom() && container.getTo() >= contained.getTo();
    }

    private Range getRangeOfContainingChild(IntervalTreeNode n, Range r) {
        int childRangeLength = n.range.getLength() / this.arity;
        for (int i = 0; i < this.arity; ++i) {
            int childRangeEnd;
            int childRangeStart = i * childRangeLength + n.range.getFrom();
            Range childRange = new Range(childRangeStart, childRangeEnd = childRangeStart + childRangeLength);
            if (!this.contains(childRange, r)) continue;
            return childRange;
        }
        return null;
    }

    public List<IntervalTreeNode> getNodes() {
        return this.nodes;
    }

    public IntervalTreeNode getNodeWithSmallestMax() {
        return this.getNodeWithSmallestMax(this.root);
    }

    private IntervalTreeNode getNodeWithSmallestMax(IntervalTreeNode node) {
        if (node.isLeaf()) {
            return node;
        }
        int indexofsmallestmax = -1;
        int smallestmax = Integer.MAX_VALUE;
        for (int i = 0; i < node.children.size(); ++i) {
            IntervalTreeNode c = node.children.get(i);
            if (c.range.getTo() >= smallestmax) continue;
            smallestmax = c.range.getTo();
            indexofsmallestmax = i;
        }
        return this.getNodeWithSmallestMax(node.children.get(indexofsmallestmax));
    }

    public void removeNode(IntervalTreeNode node) {
        this.nodes.set(node.index, null);
        if (node.parent != null) {
            node.parent.children.remove(node);
        } else {
            this.root = null;
        }
    }
}

