/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.file.SavantROFile;
import savant.util.SavantFileUtils;

public class ContinuousFormatterHelper {
    private static final Log LOG = LogFactory.getLog(ContinuousFormatterHelper.class);
    public static final int NOTIONAL_SCREEN_SIZE = 1000;

    public static Map<String, List<Level>> readLevelHeaders(SavantROFile savantFile) throws IOException {
        Map<String, long[]> refMap = SavantFileUtils.readReferenceMap(savantFile);
        savantFile.setHeaderOffset(savantFile.getFilePointer());
        HashMap<String, List<Level>> headers = new HashMap<String, List<Level>>();
        int headerNum = 0;
        LOG.debug((Object)("Number of headers to get: " + refMap.keySet().size()));
        long maxend = Long.MIN_VALUE;
        for (String refname : refMap.keySet()) {
            long[] v = refMap.get(refname);
            savantFile.seek(v[0] + savantFile.getHeaderOffset());
            int numLevels = savantFile.readInt();
            ArrayList<Level> levels = new ArrayList<Level>(numLevels);
            for (int i = 0; i < numLevels; ++i) {
                levels.add(new Level(savantFile));
            }
            maxend = Math.max(maxend, savantFile.getFilePointer());
            headers.put(refname, levels);
            ++headerNum;
        }
        savantFile.setHeaderOffset(maxend);
        return headers;
    }

    public static class VariableStepMode
    extends Mode {
        public int start;
        public int span;

        public VariableStepMode(int start, int span) {
            super(Mode.ModeType.VARIABLESTEP);
            this.start = start;
            this.span = span;
        }

        public VariableStepMode(SavantROFile savantFile) {
            super(Mode.ModeType.VARIABLESTEP);
            throw new UnsupportedOperationException("Reading variable-step mode not implemented.");
        }

        @Override
        public void write(DataOutputStream o) {
            throw new UnsupportedOperationException("Writing variable-step mode not supported.");
        }
    }

    public static class FixedMode
    extends Mode {
        public int start;
        public int step;
        public int span;

        public FixedMode(int start, int step, int span) {
            super(Mode.ModeType.FIXED);
            this.start = start;
            this.step = step;
            this.span = span;
        }

        public FixedMode(SavantROFile savantFile) throws IOException {
            super(Mode.ModeType.FIXED);
            this.start = savantFile.readInt();
            this.step = savantFile.readInt();
            this.span = savantFile.readInt();
        }

        @Override
        public void write(DataOutputStream o) throws IOException {
            super.write(o);
            o.writeInt(this.start);
            o.writeInt(this.step);
            o.writeInt(this.span);
        }
    }

    public static class Mode {
        public ModeType type;

        public Mode(ModeType t) {
            this.type = t;
        }

        public void write(DataOutputStream o) throws IOException {
            o.writeInt(this.type.ordinal());
        }

        public static enum ModeType {
            FIXED,
            VARIABLESTEP;

        }
    }

    public static class Level {
        public long offset;
        public long size;
        public long recordSize;
        public long resolution;
        public Mode mode;

        public Level(long offset, long size, long recordSize, long resolution, Mode m) {
            this.offset = offset;
            this.size = size;
            this.recordSize = recordSize;
            this.resolution = resolution;
            this.mode = m;
        }

        public Level(SavantROFile savantFile) throws IOException {
            this.offset = savantFile.readLong();
            this.size = savantFile.readLong();
            this.recordSize = savantFile.readLong();
            this.resolution = savantFile.readLong();
            this.mode = ((Mode.ModeType[])Mode.ModeType.class.getEnumConstants())[savantFile.readInt()] == Mode.ModeType.FIXED ? new FixedMode(savantFile) : new VariableStepMode(savantFile);
        }

        public void writeHeader(DataOutputStream o) throws IOException {
            o.writeLong(this.offset);
            o.writeLong(this.size);
            o.writeLong(this.recordSize);
            o.writeLong(this.resolution);
            this.mode.write(o);
        }
    }
}

