/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.util.ArrayList;
import java.util.List;
import savant.api.data.Block;
import savant.api.data.RichIntervalRecord;
import savant.api.data.Strand;
import savant.data.types.ItemRGB;
import savant.data.types.TabixIntervalRecord;
import savant.util.ColumnMapping;

public class TabixRichIntervalRecord
extends TabixIntervalRecord
implements RichIntervalRecord {
    protected TabixRichIntervalRecord(String line, ColumnMapping mapping) {
        super(line, mapping);
    }

    @Override
    public String getAlternateName() {
        return this.mapping.name2 >= 0 ? this.values[this.mapping.name2] : null;
    }

    @Override
    public List<Block> getBlocks() {
        boolean relativeStarts;
        ArrayList<Block> blocks = null;
        boolean bl = relativeStarts = this.mapping.blockStartsRelative >= 0;
        if (relativeStarts || this.mapping.blockStartsAbsolute >= 0) {
            int[] blockStarts = Block.extractBlocks(this.values[relativeStarts ? this.mapping.blockStartsRelative : this.mapping.blockStartsAbsolute]);
            blocks = new ArrayList<Block>(blockStarts.length);
            int offset = relativeStarts ? 0 : this.getInterval().getStart();
            int endExtra = 1;
            if (!this.mapping.oneBased) {
                endExtra = 0;
                if (!relativeStarts) {
                    --offset;
                }
            }
            if (this.mapping.blockEnds >= 0) {
                int[] blockEnds = Block.extractBlocks(this.values[this.mapping.blockEnds]);
                for (int i = 0; i < blockEnds.length; ++i) {
                    blocks.add(Block.valueOf(blockStarts[i] - offset, blockEnds[i] - blockStarts[i] + endExtra));
                }
            } else if (this.mapping.blockSizes >= 0) {
                int[] blockSizes = Block.extractBlocks(this.values[this.mapping.blockSizes]);
                for (int i = 0; i < blockSizes.length; ++i) {
                    blocks.add(Block.valueOf(blockStarts[i] - offset, blockSizes[i] + endExtra));
                }
            } else {
                throw new IllegalArgumentException("No column provided for block ends/sizes.");
            }
        }
        return blocks;
    }

    @Override
    public float getScore() {
        return this.mapping.score >= 0 ? Float.parseFloat(this.values[this.mapping.score]) : Float.NaN;
    }

    @Override
    public Strand getStrand() {
        if (this.mapping.strand >= 0 && this.values[this.mapping.strand].length() > 0) {
            switch (this.values[this.mapping.strand].charAt(0)) {
                case '-': {
                    return Strand.REVERSE;
                }
            }
            return Strand.FORWARD;
        }
        return Strand.FORWARD;
    }

    @Override
    public int getThickStart() {
        if (this.mapping.thickStart >= 0) {
            int result = Integer.parseInt(this.values[this.mapping.thickStart]);
            return this.mapping.oneBased ? result : result + 1;
        }
        return this.interval.getStart();
    }

    @Override
    public int getThickEnd() {
        return this.mapping.thickEnd >= 0 ? Integer.parseInt(this.values[this.mapping.thickEnd]) : this.interval.getEnd();
    }

    @Override
    public ItemRGB getItemRGB() {
        return this.mapping.itemRGB >= 0 ? ItemRGB.parseItemRGB(this.values[this.mapping.itemRGB]) : null;
    }
}

