/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import savant.api.data.ContinuousRecord;

public class GenericContinuousRecord
implements ContinuousRecord {
    public static final String[] COLUMN_NAMES = new String[]{"Reference", "Position", "Value"};
    private final String reference;
    private final float value;
    private final int position;

    protected GenericContinuousRecord(String reference, int position, float value) {
        if (reference == null) {
            throw new IllegalArgumentException("Reference may not be null.");
        }
        this.reference = reference;
        this.position = position;
        this.value = value;
    }

    public static GenericContinuousRecord valueOf(String reference, int position, float value) {
        return new GenericContinuousRecord(reference, position, value);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericContinuousRecord that = (GenericContinuousRecord)o;
        if (this.position != that.position) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = this.reference.hashCode();
        result = 31 * result + Float.floatToIntBits(this.value);
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericContinuousRecord");
        sb.append("{reference='").append(this.reference).append('\'');
        sb.append(", value=").append(this.value);
        sb.append(", position=").append(this.position);
        sb.append('}');
        return sb.toString();
    }

    public int compareTo(Object o) {
        GenericContinuousRecord that = (GenericContinuousRecord)o;
        if (!this.reference.equals(that.getReference())) {
            String a1 = this.reference;
            String a2 = that.getReference();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
        }
        if (this.getPosition() == that.getPosition()) {
            return 0;
        }
        if (this.getPosition() < that.getPosition()) {
            return -1;
        }
        return 1;
    }
}

