/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableStream;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.SequenceDataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.data.SequenceRecord;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.util.FastaUtils;
import savant.util.IndexCache;
import savant.util.NetworkUtils;
import savant.view.tracks.TrackCreationEvent;
import savant.view.tracks.TrackFactory;

public class FastaDataSource
extends DataSource<SequenceRecord>
implements SequenceDataSourceAdapter {
    private URI fastaURI;
    private SeekableStream stream;
    private Map<String, FastaUtils.IndexEntry> index;

    public FastaDataSource(URI uri, TrackFactory.TrackCreationListener l) throws IOException {
        this.fastaURI = uri;
        try {
            File faiFile = IndexCache.getIndexFile(uri, "fai", "fa");
            this.index = FastaUtils.readIndex(faiFile);
        }
        catch (FileNotFoundException x) {
            if (l != null) {
                l.handleEvent(new TrackCreationEvent("Generating index...", -1.0));
            }
            this.index = FastaUtils.createIndex(uri, new File(x.getMessage()));
        }
        this.stream = new SeekableBufferedStream(NetworkUtils.getSeekableStreamForURI(uri));
    }

    @Override
    public int getLength(String ref) {
        return this.index.get((Object)ref).length;
    }

    public List<SequenceRecord> getRecords(String ref, RangeAdapter r, Resolution res, RecordFilterAdapter filt) throws IOException {
        FastaUtils.IndexEntry entry = this.index.get(ref);
        if (entry != null) {
            int c;
            byte[] sequence = new byte[r.getLength()];
            int i = 0;
            int lineNum = (r.getFrom() - 1) / entry.lineLength;
            long offset = entry.offset + (long)(lineNum * (entry.lineLength + 1)) + (long)((r.getFrom() - 1) % entry.lineLength);
            this.stream.seek(offset);
            while ((c = this.stream.read()) >= 0 && i < sequence.length) {
                if (c == 10) continue;
                sequence[i++] = (byte)Character.toUpperCase(c);
            }
            return Arrays.asList(SequenceRecord.valueOf(ref, sequence));
        }
        return null;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<String> getReferenceNames() {
        return this.index.keySet();
    }

    @Override
    public URI getURI() {
        return this.fastaURI;
    }

    @Override
    public final DataFormat getDataFormat() {
        return DataFormat.SEQUENCE;
    }

    @Override
    public final String[] getColumnNames() {
        return new String[]{"Sequence"};
    }
}

