/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import savant.api.adapter.RangeAdapter;
import savant.util.Range;

public class RangeUtils {
    public static RangeAdapter createRange(int from, int to) {
        return new Range(from, to);
    }

    public static boolean contains(RangeAdapter r1, RangeAdapter r2) {
        return r1.getFrom() <= r2.getFrom() && r1.getTo() >= r2.getTo();
    }

    public static boolean intersects(RangeAdapter r1, RangeAdapter r2) {
        return r1.getFrom() <= r2.getTo() && r1.getTo() >= r2.getFrom();
    }

    public static RangeAdapter union(RangeAdapter r1, RangeAdapter r2) {
        return new Range(Math.min(r1.getFrom(), r2.getFrom()), Math.max(r1.getTo(), r2.getTo()));
    }

    public static RangeAdapter[] subtract(RangeAdapter r1, RangeAdapter r2) {
        if (r1.getTo() < r2.getFrom() || r1.getFrom() > r2.getTo()) {
            return new RangeAdapter[]{r1};
        }
        if (r1.getFrom() < r2.getFrom()) {
            if (r1.getTo() <= r2.getTo()) {
                return new RangeAdapter[]{RangeUtils.createRange(r1.getFrom(), r2.getFrom() - 1)};
            }
            return new RangeAdapter[]{RangeUtils.createRange(r1.getFrom(), r2.getFrom() - 1), RangeUtils.createRange(r2.getTo() + 1, r1.getTo())};
        }
        if (r1.getTo() > r2.getTo()) {
            return new RangeAdapter[]{RangeUtils.createRange(r2.getTo() + 1, r1.getTo())};
        }
        return new RangeAdapter[0];
    }

    public static RangeAdapter addMargin(RangeAdapter r) {
        int buffer = Math.max(250, r.getLength() / 4);
        int newStart = Math.max(1, r.getFrom() - buffer);
        return new Range(newStart, r.getTo() + buffer);
    }
}

