/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import java.io.File;
import java.net.URL;
import javax.swing.JPanel;
import savant.api.event.PluginEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.plugin.PluginController;
import savant.settings.DirectorySettings;
import savant.view.dialog.DownloadDialog;
import savant.view.swing.Savant;

public class PluginUtils {
    public static void addPluginListener(Listener<PluginEvent> l) {
        PluginController.getInstance().addListener(l);
    }

    public static void removePluginListener(Listener<PluginEvent> l) {
        PluginController.getInstance().removeListener(l);
    }

    public static void installPlugin(URL url) {
        DownloadDialog dd = new DownloadDialog(DialogUtils.getMainWindow(), true);
        dd.downloadFile(url, DirectorySettings.getPluginsDirectory(), null);
        if (dd.getDownloadedFile() != null) {
            PluginUtils.installPlugin(dd.getDownloadedFile());
        }
    }

    public static void installPlugin(File f) {
        try {
            PluginController.getInstance().installPlugin(f);
        }
        catch (Throwable x) {
            DialogUtils.displayException("Installation Error", String.format("<html>Unable to install <i>%s</i>: %s.</html>", f.getName(), x), x);
        }
    }

    public static JPanel getPluginToolbar() {
        return Savant.getInstance().getPluginToolbar();
    }
}

