/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import savant.api.adapter.RangeAdapter;
import savant.api.event.LocationChangeCompletedEvent;
import savant.api.event.LocationChangedEvent;
import savant.api.util.Listener;
import savant.controller.LocationController;
import savant.util.MiscUtils;
import savant.util.Range;

public class NavigationUtils {
    private static LocationController lc = LocationController.getInstance();
    private static List<Listener<LocationChangeCompletedEvent>> completionListeners = new ArrayList<Listener<LocationChangeCompletedEvent>>();

    public static String getCurrentReferenceName() {
        return lc.getReferenceName();
    }

    public static Set<String> getReferenceNames() {
        return lc.getReferenceNames();
    }

    public static RangeAdapter getCurrentReferenceRange() {
        return lc.getMaxRange();
    }

    public void navigateTo(String ref) {
        lc.setLocation(ref, false);
    }

    public static void navigateTo(RangeAdapter range) {
        lc.setLocation((Range)range);
    }

    public static void navigateTo(String ref, RangeAdapter range) {
        lc.setLocation(NavigationUtils.homogeniseRef(ref), (Range)range);
    }

    public static RangeAdapter getCurrentRange() {
        return lc.getRange();
    }

    public static synchronized void addLocationChangedListener(Listener<LocationChangedEvent> l) {
        lc.addListener(l);
    }

    public static synchronized void removeLocationChangedListener(Listener<LocationChangedEvent> l) {
        lc.removeListener(l);
    }

    public static synchronized void addLocationChangeCompletedListener(Listener<LocationChangeCompletedEvent> l) {
        completionListeners.add(l);
    }

    public static synchronized void removeLocationChangeCompletedListener(Listener<LocationChangeCompletedEvent> l) {
        completionListeners.remove(l);
    }

    public static String homogeniseRef(String orig) {
        if (!lc.getAllReferenceNames().contains(orig)) {
            for (String ref : lc.getAllReferenceNames()) {
                if (!MiscUtils.homogenizeSequence(ref).equals(orig)) continue;
                return ref;
            }
        }
        return orig;
    }

    public static void fireLocationChangeCompletedEvent() {
        for (Listener<LocationChangeCompletedEvent> l : completionListeners) {
            l.handleEvent(new LocationChangeCompletedEvent());
        }
    }
}

