/*
 * Decompiled with CFR 0.152.
 */
package savant.api.data;

import savant.api.adapter.RangeAdapter;

public final class Interval
implements Comparable<Interval> {
    private final int start;
    private final int end;

    private Interval(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public static Interval valueOf(int start, int end) {
        return new Interval(start, end);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public boolean intersects(Interval i2) {
        return this.start < i2.end && i2.start < this.end;
    }

    public boolean intersectsOrAbuts(Interval i2) {
        return this.start < i2.end - 1 && i2.start < this.end - 1;
    }

    public Interval merge(Interval i2) {
        if (this.intersectsOrAbuts(i2)) {
            return Interval.valueOf(Math.min(this.start, i2.start), Math.max(this.end, i2.end));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        if (this.end != interval.end) {
            return false;
        }
        return this.start == interval.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return this.getStart() + " - " + this.getEnd();
    }

    @Override
    public int compareTo(Interval that) {
        if (this.start < that.start) {
            return -1;
        }
        if (this.start > that.start) {
            return 1;
        }
        return this.end - that.end;
    }

    public boolean intersectsRange(RangeAdapter r) {
        return this.start <= r.getTo() && this.end >= r.getFrom();
    }
}

