/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.broad.tribble.util.SeekableStream;

public class SeekableFileStream
extends SeekableStream {
    private static Logger log = Logger.getLogger(SeekableFileStream.class);
    static Collection<SeekableFileStream> allInstances = Collections.synchronizedCollection(new HashSet());
    File file;
    FileInputStream fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new FileInputStream(file);
        allInstances.add(this);
    }

    @Override
    public boolean eof() throws IOException {
        return this.file.length() == this.fis.getChannel().position();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.fis.getChannel().position(position);
    }

    @Override
    public long position() throws IOException {
        return this.fis.getChannel().position();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.fis.read(buffer, offset, length);
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.fis.read(b);
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public void mark(int readlimit) {
        this.fis.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.fis.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.fis.reset();
    }

    @Override
    public void close() throws IOException {
        allInstances.remove(this);
        this.fis.close();
    }
}

