/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SortingCollection;
import org.broad.igv.tools.sort.BedSorter;
import org.broad.igv.tools.sort.GFFSorter;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.tools.sort.SortableRecordCodec;
import org.broad.igv.tools.sort.SortedTxtSorter;
import org.broad.igv.tools.sort.VCFSorter;
import org.broad.tribble.readers.AsciiLineReader;

public abstract class Sorter {
    static int MAX_RECORDS_IN_RAM = 500000;
    protected File inputFile;
    protected File outputFile;
    private int maxRecords = MAX_RECORDS_IN_RAM;
    private File tmpDir;
    static final String usageString = "igvtools sort <inputFile> [outputFile]";

    public static Sorter getSorter(File inputFile, File outputFile) {
        String shortFN = inputFile.getName().toLowerCase();
        if (shortFN.endsWith(".txt")) {
            shortFN = shortFN.substring(0, shortFN.length() - 4);
        }
        if (shortFN.endsWith(".sam")) {
            return new SAMSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".aligned") || shortFN.endsWith(".bed")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sorted")) {
            return new SortedTxtSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".gff")) {
            return new GFFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".vcf")) {
            return new VCFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".psl") || shortFN.endsWith(".pslx")) {
            return new BedSorter(inputFile, outputFile);
        }
        System.out.println("Unknown file type or sorting not supported for: " + inputFile.getName());
        return null;
    }

    public Sorter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        InputStream fis = null;
        PrintWriter writer = null;
        try {
            fis = this.getInput();
            writer = this.getOutput();
            SortableRecordCodec codec = new SortableRecordCodec();
            Comparator<SortableRecord> comp = new Comparator<SortableRecord>(){

                @Override
                public int compare(SortableRecord o1, SortableRecord o2) {
                    String chr1 = o1.getChromosome().replaceFirst("chr", "");
                    String chr2 = o2.getChromosome().replaceFirst("chr", "");
                    int s1 = Integer.MAX_VALUE;
                    try {
                        s1 = Integer.parseInt(chr1);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int s2 = Integer.MAX_VALUE;
                    try {
                        s2 = Integer.parseInt(chr2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int t1 = s1 - s2;
                    if (t1 == 0) {
                        chr1 = chr1.replace("M", "Z");
                        chr2 = chr2.replace("M", "Z");
                        t1 = chr1.compareTo(chr2);
                    }
                    if (t1 == 0) {
                        return o1.getStart() - o2.getStart();
                    }
                    return t1;
                }
            };
            SortingCollection cltn = SortingCollection.newInstance(SortableRecord.class, (SortingCollection.Codec)codec, (Comparator)comp, (int)this.maxRecords, (File[])new File[]{this.tmpDir});
            Parser parser = this.getParser();
            AsciiLineReader reader = new AsciiLineReader(fis);
            String firstDataRow = this.writeHeader(reader, writer);
            if (firstDataRow != null) {
                cltn.add((Object)parser.createRecord(firstDataRow));
            }
            SortableRecord next = null;
            while ((next = parser.readNextRecord(reader)) != null) {
                cltn.add((Object)next);
            }
            CloseableIterator iter = cltn.iterator();
            while (iter.hasNext()) {
                SortableRecord al = (SortableRecord)iter.next();
                writer.println(al.getText());
            }
            iter.close();
        }
        finally {
            try {
                fis.close();
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public abstract Parser getParser() throws IOException;

    public abstract String writeHeader(AsciiLineReader var1, PrintWriter var2) throws IOException;

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public InputStream getInput() throws FileNotFoundException {
        return new FileInputStream(this.inputFile);
    }

    public PrintWriter getOutput() throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
    }
}

