package org.genemania.dw.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;

/**
 * Gen utility methods and atts. Implements simple logging/timer.
 * Controlled vocab for commonly used separators.
 * The class serves both the GeneMania and the PathwayCommons classes.
 *
 * @author rashadbadrawi
 */

public class GenUtil {

    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String AT = "@";
    public static final String SEMICOLON = ";";
    public static final String COLON = ":";
    public static final String NEWLINE = System.getProperty ("line.separator");
    public static final String SPACE = " ";
    public static final String POUND = "#";
    public static final String PIPE = "|";
    public static final String FORWARD_SLASH = "/";
    public static final String DOUBLE_BACK_SLASH = "\\";
    public static final String HYPHEN = "-";
    public static final String UNDERSCORE = "_";
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String NA = "N/A";
    public static final String ALL = "ALL";

    private static PrintWriter log;
    private static long startTime;
    
    static {
        String fileName = null;
        try {
            fileName = System.getProperty (DefParams.LOG_FILE_PROP);
            if (fileName != null) {
                log = new PrintWriter (fileName);
            } else {
                log = new PrintWriter (DefParams
                    .getDefaultProp (DefParams.LOG_FILE_PROP));
            }
        } catch (IOException e) {
            System.err.println ("Unable to initialize log file:" +
                fileName + " " + DefParams.LOG_FILE_PROP);
        }
    }

    private GenUtil () {}                              //no instances allowed

    public static PrintWriter getDefaultLog () { 
    
        log.flush();
        
        return log;
    }
    
    public static String getTimeStamp () {
        
        return Calendar.getInstance ().getTime ().toString ();
    }
    
    public static void registerStart () {
        
        startTime = System.currentTimeMillis ();
    }
    
    public static long getExecTime () {
        
        return (System.currentTimeMillis () - GenUtil.startTime);
    }
    
    public static String getExecTimeStr () {
        
        StringBuffer timingBuf = new StringBuffer ();
        timingBuf.append ("Time app. (msec): ");
        timingBuf.append (getExecTime ());
        timingBuf.append (GenUtil.NEWLINE);
        
        return timingBuf.toString ();
    }

    public static void validateNotNull (Object obj) {

        if (obj == null) {
            throw new IllegalArgumentException ("Invalid value for param: " +
                                                obj);
        }
    }

    public static void validateString (String param) {
        
        if (param == null || param.length () == 0) {
            throw new IllegalArgumentException ("Invalid value for param: " +
                    param);
        }
    }
    
    public static void validatePositiveInt (int param) {
        
        if (param <= 0) {
            throw new IllegalArgumentException ("Invalid value for param: " +
                    param);
        }
    }

    public static void validateNonNegativeInt (int param) {

        if (param < 0) {
            throw new IllegalArgumentException ("Invalid value for param: " +
                    param);
        }
    }
    
    //list helper method
    public static String addList (String tempStr, ArrayList <String> tempList) {
        
        for (int i = 0; i < tempList.size (); i++) {
            if (i > 0) {
                tempStr += GenUtil.SEMICOLON;
            }
            tempStr += tempList.get (i);
        }
        if (tempList.size () == 0) {
            tempStr += GenUtil.NA;
        }
        
        return tempStr;
    }

      //list helper method: takes a file with a single column string list and
    //returns a filtered file.
    public static void filterList (String fileName) throws IOException {

        final String FILTERED = "FILTERED";
        BufferedReader br = new BufferedReader (new FileReader (fileName));
        ArrayList <String> tempList = new ArrayList <String> ();
        String line;
        while ((line = br.readLine ()) != null) {
            line = line.trim ();
            if (line.length () == 0) {
                continue;
            }
            if (!tempList.contains (line)) {
                tempList.add (line);
            }
        }
        BufferedWriter bw = new BufferedWriter (new FileWriter (fileName +
                                               GenUtil.UNDERSCORE + FILTERED));
        for (int i = 0; i < tempList.size (); i++) {
            bw.write(tempList.get (i));
            bw.newLine();
        }
        bw.flush();
        bw.close();
    }
}
