package org.genemania.dw.db;

import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;

/**
 * DBMS related utils. Default DB server is the localhost. Pooling and statement
 * caching presumably handled by the driver.
 * 
 * @author rashadbadrawi
 */

public class DBUtil {
   
    public static final String LOAD = "LOAD";
    private static final String JDBC_MYSQL = "jdbc:mysql://";   //port 3306   
    private static final String DBUSER = "user";
    private static final String DBPASSWD = "password";
    
    private static PrintWriter log = GenUtil.getDefaultLog();
    private static String DBServer;
    private static Connection con;
    private static Properties conProps; 
    
    static {
        registerDriver ();
    }

    private DBUtil () {}                            //no instances allowed

    private static void registerDriver () {
        
        try {
            DriverManager.registerDriver (new com.mysql.jdbc.Driver ());
            DBServer = DefParams.getDefaultProp (DefParams.DB_SERVER_PROP);
            //System.out.println ("DBServer is: " + DBServer.toString ());
            conProps = new Properties ();
            conProps.setProperty (DBUSER, DefParams.getDefaultProp (DefParams.DB_USER_PROP));
            conProps.setProperty (DBPASSWD, DefParams.getDefaultProp (DefParams.DB_PASSWD_PROP));
            conProps.setProperty ("sendStringParametersAsUnicode", "false");
            //conProps.setProperty ("disableStatementPooling", "false");
            //conProps.list(log);
        } catch (Exception e) {
            System.err.println ("Unable to register DB Driver.");
            e.printStackTrace ();
        }
    }
    
    public static Connection getConnection () throws SQLException {

        if (log == null) {
            log = GenUtil.getDefaultLog ();
        }
        if (con == null || con.isClosed ()) {
            try {
                if (DBServer == null){
                    DBServer = java.net.InetAddress.getLocalHost ().getHostAddress ();
                }
            } catch (java.net.UnknownHostException e) {
                e.printStackTrace ();
                e.printStackTrace (log);
                DBServer = DefParams.getDefaultProp (DefParams.DB_SERVER_PROP);
            }

            con = DriverManager.getConnection (DBUtil.JDBC_MYSQL + 
                 DBServer, conProps); 
//                 + DBUSER + "=" +
//                 DefParams.getDefaultProp (DefParams.DB_USER_PROP) + 
//                 ";" + DBPASSWD + "=" +
//                DefParams.getDefaultProp (DefParams.DB_PASSWD_PROP)); 
            //log warnings
            for(SQLWarning warn = con.getWarnings (); warn != null;
                warn = warn.getNextWarning () ) {
                log.println ("SQL Warning:");
                log.println ("State  : " + warn.getSQLState ());
                log.println ("Message: " + warn.getMessage ());
                log.println ("Error  : " + warn.getErrorCode ());
            }
            con.setAutoCommit (false);        
        }

        return con;
    }
}