/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib.properties;

import hidden.org.apache.webdav.lib.BaseProperty;
import hidden.org.apache.webdav.lib.ResponseEntity;
import hidden.org.apache.webdav.lib.util.DOMUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Element;

public abstract class DateProperty
extends BaseProperty {
    private static final SimpleDateFormat[] FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US)};

    public DateProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Date getDate() {
        String dateString = DOMUtils.getTextValue(this.element);
        for (int i = 0; i < FORMATS.length; ++i) {
            try {
                return FORMATS[i].parse(dateString);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }
}

