/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import org.genemania.dw.util.DefParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenUtil {
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String AT = "@";
    public static final String SEMICOLON = ";";
    public static final String COLON = ":";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String SPACE = " ";
    public static final String POUND = "#";
    public static final String PIPE = "|";
    public static final String FORWARD_SLASH = "/";
    public static final String DOUBLE_BACK_SLASH = "\\";
    public static final String HYPHEN = "-";
    public static final String UNDERSCORE = "_";
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String NA = "N/A";
    public static final String ALL = "ALL";
    private static PrintWriter log;
    private static long startTime;

    private GenUtil() {
    }

    public static PrintWriter getDefaultLog() {
        log.flush();
        return log;
    }

    public static String getTimeStamp() {
        return Calendar.getInstance().getTime().toString();
    }

    public static void registerStart() {
        startTime = System.currentTimeMillis();
    }

    public static long getExecTime() {
        return System.currentTimeMillis() - startTime;
    }

    public static String getExecTimeStr() {
        StringBuffer timingBuf = new StringBuffer();
        timingBuf.append("Time app. (msec): ");
        timingBuf.append(GenUtil.getExecTime());
        timingBuf.append(NEWLINE);
        return timingBuf.toString();
    }

    public static void validateNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Invalid value for param: " + obj);
        }
    }

    public static void validateString(String param) {
        if (param == null || param.length() == 0) {
            throw new IllegalArgumentException("Invalid value for param: " + param);
        }
    }

    public static void validatePositiveInt(int param) {
        if (param <= 0) {
            throw new IllegalArgumentException("Invalid value for param: " + param);
        }
    }

    public static void validateNonNegativeInt(int param) {
        if (param < 0) {
            throw new IllegalArgumentException("Invalid value for param: " + param);
        }
    }

    public static String addList(String tempStr, ArrayList<String> tempList) {
        for (int i = 0; i < tempList.size(); ++i) {
            if (i > 0) {
                tempStr = tempStr + SEMICOLON;
            }
            tempStr = tempStr + tempList.get(i);
        }
        if (tempList.size() == 0) {
            tempStr = tempStr + NA;
        }
        return tempStr;
    }

    public static void filterList(String fileName) throws IOException {
        String line;
        String FILTERED = "FILTERED";
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        ArrayList<String> tempList = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || tempList.contains(line)) continue;
            tempList.add(line);
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName + UNDERSCORE + "FILTERED"));
        for (int i = 0; i < tempList.size(); ++i) {
            bw.write((String)tempList.get(i));
            bw.newLine();
        }
        bw.flush();
        bw.close();
    }

    static {
        String fileName = null;
        try {
            fileName = System.getProperty("DefLogFile");
            log = fileName != null ? new PrintWriter(fileName) : new PrintWriter(DefParams.getDefaultProp("DefLogFile"));
        }
        catch (IOException e) {
            System.err.println("Unable to initialize log file:" + fileName + SPACE + "DefLogFile");
        }
    }
}

