/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.genemania.dw.db.DBUtil;
import org.genemania.dw.entity.EnsemblGene;
import org.genemania.dw.entity.EntrezGene;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.entity.TAIRGene;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntrezMirrorTables {
    private static final String GENE_INFO_TABLE = "Gene_Info";
    private static final String GENE2ACCN_TABLE = "Gene2Accession";
    private static final String GENE2REFSEQ_TABLE = "Gene2RefSeq";
    private static final String GENE_HISTORY_TABLE = "Gene_History";
    private static final String GENE2UNIPROT_TABLE = "Gene_Refseq_Uniprotkb_Collab";
    private static final String TAX_NAMES_TABLE = "TaxonomyNames";
    private static final String TAX_ID_COL = "tax_id";
    private static final String GENE_ID_COL = "GeneID";
    private static final String SYMBOL_COL = "Symbol";
    private static final String SYNS_COL = "Synonyms";
    private static final String XREF_COL = "dbXrefs";
    private static final String DESC_COL = "description";
    private static final String TYPE_COL = "type_of_gene";
    private static final String RNA_ACCN_COL = "RNA_nucleotide_accession";
    private static final String PRO_ACCN_COL = "protein_accession";
    private static final String RNA_GI_ACCN_COL = "RNA_nucleotide_gi";
    private static final String PRO_GI_ACCN_COL = "protein_gi";
    private static final String GEN_GI_ACCN_COL = "genomic_nucleotide_gi";
    private static final String NCBI_ACCN_COL = "NCBI_protein_accession";
    private static final String UNIPROT_COL = "UniProtKB_protein_accession";
    private static final String OLD_GENE_ID_COL = "Discontinued_GeneID";
    private static final String NAME_COL = "Name";
    private static final String NAME_CLASS_COL = "NameClass";
    private static final String SPID_MGD = "MGI";
    private static String DBName;
    private static PrintWriter log;

    private EntrezMirrorTables() {
    }

    public static TreeMap<String, ExtResource> loadAll(String speciesName) throws SQLException {
        System.out.println("loading all Entrez genes...");
        TreeMap<String, ExtResource> entGeneMap = new TreeMap<String, ExtResource>();
        String loadQuery = "select GeneID, Symbol, Synonyms, dbXrefs, description, type_of_gene from " + DBName + "." + GENE_INFO_TABLE + " where " + TAX_ID_COL + " = ?";
        log.println("LOAD: " + loadQuery);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            int taxID = EntrezMirrorTables.getTaxID(speciesName);
            ps.setInt(1, taxID);
            rs = ps.executeQuery();
            int cnt = 0;
            EntrezGene DBEntGene = null;
            while (rs.next()) {
                DBEntGene = EntrezMirrorTables.getResults(rs, DBEntGene, speciesName);
                EntrezMirrorTables.loadRefSeq(taxID, DBEntGene);
                EntrezMirrorTables.loadUniprot(DBEntGene);
                entGeneMap.put(DBEntGene.getID(), DBEntGene);
                ++cnt;
            }
            System.out.println("Loaded: " + cnt + " Entrez entries, for " + "species: " + speciesName + " (" + taxID + ")");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        return entGeneMap;
    }

    public static ExtResource load(String speciesName, String geneID) throws SQLException {
        String loadQuery = "select GeneID, Symbol, Synonyms, dbXrefs, description, type_of_gene from " + DBName + "." + GENE_INFO_TABLE + " where " + TAX_ID_COL + " = ? and " + GENE_ID_COL + " = ?";
        log.println("LOAD: " + loadQuery);
        Connection con = null;
        PreparedStatement loadSingleStmt = null;
        ResultSet rs = null;
        EntrezGene DBEntGene = null;
        try {
            con = DBUtil.getConnection();
            loadSingleStmt = con.prepareStatement(loadQuery);
            int taxID = EntrezMirrorTables.getTaxID(speciesName);
            loadSingleStmt.setInt(1, taxID);
            loadSingleStmt.setString(2, geneID);
            rs = loadSingleStmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                DBEntGene = EntrezMirrorTables.getResults(rs, DBEntGene, speciesName);
                EntrezMirrorTables.loadRefSeq(taxID, DBEntGene);
                EntrezMirrorTables.loadUniprot(DBEntGene);
                ++cnt;
            }
            if (cnt > 1) {
                System.err.println("More than one match for Entrez gene ID: " + geneID + " " + cnt);
            }
        }
        catch (SQLException e) {
            if (con != null && !con.isClosed()) {
                con.close();
            }
            throw e;
        }
        finally {
            if (loadSingleStmt != null) {
                loadSingleStmt.close();
            }
        }
        return DBEntGene;
    }

    private static void loadRefSeq(int taxID, EntrezGene entGene) throws SQLException {
        String loadQuery = "select RNA_nucleotide_accession, protein_accession from " + DBName + "." + GENE2REFSEQ_TABLE + " where " + TAX_ID_COL + " = ? and " + GENE_ID_COL + " = ?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            ps.setInt(1, taxID);
            ps.setString(2, entGene.getID());
            rs = ps.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String[] tempArr;
                if (!"-".equals(rs.getString(RNA_ACCN_COL))) {
                    tempArr = rs.getString(RNA_ACCN_COL).split("\\.");
                    entGene.addRefSeqRNAID(tempArr[0]);
                }
                if (!"-".equals(rs.getString(PRO_ACCN_COL))) {
                    tempArr = rs.getString(PRO_ACCN_COL).split("\\.");
                    entGene.addRefSeqProID(tempArr[0]);
                }
                ++cnt;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static ArrayList<ExtResourceGene> replaceGene(ExtResourceGene oldEntGene) throws SQLException {
        String loadQuery = "select GeneID from " + DBName + "." + GENE_HISTORY_TABLE + " where " + TAX_ID_COL + " = ? and " + OLD_GENE_ID_COL + " = ?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ExtResourceGene newEntGene = null;
        ArrayList<ExtResourceGene> replacedList = new ArrayList<ExtResourceGene>();
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            ps.setInt(1, EntrezMirrorTables.getTaxID(oldEntGene.getSpeciesName()));
            ps.setString(2, oldEntGene.getID());
            rs = ps.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                if ("-".equals(rs.getString(GENE_ID_COL))) continue;
                newEntGene = (ExtResourceGene)EntrezMirrorTables.load(oldEntGene.getSpeciesName(), rs.getString(GENE_ID_COL));
                if (newEntGene == null) {
                    System.out.println("Replacing gene is deprecated: " + rs.getString(GENE_ID_COL));
                } else {
                    replacedList.add(newEntGene);
                }
                ++cnt;
            }
            if (cnt > 1) {
                System.out.println("More than one replacement for gene ID: " + oldEntGene.getID());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return replacedList;
    }

    public static ArrayList<String> replaceGeneID(ExtResourceGene oldEntGene) throws SQLException {
        String loadQuery = "select GeneID from " + DBName + "." + GENE_HISTORY_TABLE + " where " + TAX_ID_COL + " = ? and " + OLD_GENE_ID_COL + " = ?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> replacedList = new ArrayList<String>();
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            ps.setInt(1, EntrezMirrorTables.getTaxID(oldEntGene.getSpeciesName()));
            ps.setString(2, oldEntGene.getID());
            rs = ps.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                if ("-".equals(rs.getString(GENE_ID_COL))) continue;
                replacedList.add(rs.getString(GENE_ID_COL));
                ++cnt;
            }
            if (cnt > 1) {
                System.out.println("More than one replacement for gene ID: " + oldEntGene.getID());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return replacedList;
    }

    private static void loadUniprot(EntrezGene entGene) throws SQLException {
        ArrayList<String> tempList = entGene.getRefSeqProList();
        if (tempList.size() == 0) {
            return;
        }
        String loadQuery = "select UniProtKB_protein_accession from " + DBName + "." + GENE2UNIPROT_TABLE + " where " + NCBI_ACCN_COL + " = ?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int cnt = 0;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            for (int i = 0; i < tempList.size(); ++i) {
                ps.setString(1, tempList.get(i));
                rs = ps.executeQuery();
                cnt = 0;
                while (rs.next()) {
                    entGene.addUniprotID(rs.getString(UNIPROT_COL));
                    ++cnt;
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static EntrezGene getResults(ResultSet rs, EntrezGene entGene, String speciesName) throws SQLException {
        int i;
        entGene = new EntrezGene();
        entGene.setID(rs.getString(GENE_ID_COL));
        entGene.setName(rs.getString(SYMBOL_COL));
        entGene.setType(rs.getString(TYPE_COL));
        if (!"-".equals(rs.getString(DESC_COL))) {
            entGene.setDefinition(rs.getString(DESC_COL));
        }
        entGene.setSpeciesName(speciesName);
        String tempStr = rs.getString(SYNS_COL);
        String[] tempArr = tempStr.split("\\|");
        for (i = 0; i < tempArr.length; ++i) {
            if (tempArr[i].equals("-")) continue;
            entGene.addSyn(tempArr[i]);
        }
        tempStr = rs.getString(XREF_COL);
        tempArr = tempStr.split("\\|");
        for (i = 0; i < tempArr.length; ++i) {
            String[] tempArr2;
            if (tempArr[i].equals("-")) continue;
            if (tempArr[i].startsWith("Ensembl")) {
                tempArr2 = tempArr[i].split(":");
                EnsemblGene ensGene = new EnsemblGene();
                ensGene.setID(tempArr2[1]);
                ensGene.setSpeciesName(speciesName);
                entGene.addXRef("Ensembl", ensGene);
                continue;
            }
            if (tempArr[i].startsWith("TAIR")) {
                tempArr2 = tempArr[i].split(":");
                TAIRGene tGene = new TAIRGene();
                tGene.setID(tempArr2[1]);
                entGene.addXRef("TAIR", tGene);
                continue;
            }
            if (!tempArr[i].startsWith(SPID_MGD)) continue;
            entGene.addMGDID(tempArr[i]);
        }
        return entGene;
    }

    private static int getTaxID(String speciesName) {
        int taxID = -1;
        if ("At".equals(speciesName)) {
            taxID = 3702;
        } else if ("Ce".equals(speciesName)) {
            taxID = 6239;
        } else if ("Mm".equals(speciesName)) {
            taxID = 10090;
        } else if ("Rn".equals(speciesName)) {
            taxID = 10116;
        } else if ("Sc".equals(speciesName)) {
            taxID = 4932;
        } else if ("Hs".equals(speciesName)) {
            taxID = 9606;
        } else if ("Dm".equals(speciesName)) {
            taxID = 7227;
        } else if ("Ec".equals(speciesName)) {
            taxID = 562;
        }
        return taxID;
    }

    public static ExtResource loadByGI(String speciesName, String GI) throws SQLException {
        String loadQuery = "select tax_id, GeneID, RNA_nucleotide_accession, protein_accession from " + DBName + "." + GENE2REFSEQ_TABLE + " where ";
        if (speciesName != null) {
            loadQuery = loadQuery + "tax_id = ? and ";
        }
        loadQuery = loadQuery + "(RNA_nucleotide_gi = ? or protein_gi = ? or genomic_nucleotide_gi = ?)";
        log.println("LOAD: " + loadQuery);
        Connection con = null;
        PreparedStatement loadStmt = null;
        ResultSet rs = null;
        EntrezGene DBEntGene = null;
        try {
            con = DBUtil.getConnection();
            loadStmt = con.prepareStatement(loadQuery);
            int index = 1;
            if (speciesName != null) {
                int taxID = EntrezMirrorTables.getTaxID(speciesName);
                loadStmt.setInt(index++, taxID);
            }
            loadStmt.setString(index++, GI);
            loadStmt.setString(index++, GI);
            loadStmt.setString(index++, GI);
            rs = loadStmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String[] tempArr;
                DBEntGene = new EntrezGene();
                if (speciesName != null) {
                    DBEntGene.setSpeciesName(speciesName);
                }
                DBEntGene.setID(rs.getString(GENE_ID_COL));
                if (!"-".equals(rs.getString(RNA_ACCN_COL))) {
                    tempArr = rs.getString(RNA_ACCN_COL).split("\\.");
                    DBEntGene.addRefSeqRNAID(tempArr[0]);
                }
                if (!"-".equals(rs.getString(PRO_ACCN_COL))) {
                    tempArr = rs.getString(PRO_ACCN_COL).split("\\.");
                    DBEntGene.addRefSeqRNAID(tempArr[0]);
                }
                EntrezMirrorTables.loadUniprot(DBEntGene);
                ++cnt;
            }
            if (cnt > 1) {
                System.err.println("More than one match for Entrez gene ID: " + GI + " " + cnt);
            }
        }
        catch (SQLException e) {
            if (con != null && !con.isClosed()) {
                con.close();
            }
            throw e;
        }
        finally {
            if (loadStmt != null) {
                loadStmt.close();
            }
        }
        return DBEntGene;
    }

    public static ExtResource loadByAccn(String speciesName, String accnType, String accnID) throws SQLException {
        String loadQuery = "select tax_id, GeneID, RNA_nucleotide_accession, protein_accession from " + DBName + "." + GENE2REFSEQ_TABLE + " where ";
        if (speciesName != null) {
            loadQuery = loadQuery + "tax_id = ? and ";
        }
        boolean wildFlag = false;
        if ("RefSeqRNA".equals(accnType)) {
            if (!accnID.contains(".")) {
                loadQuery = loadQuery + "RNA_nucleotide_accession like (?) or ";
                wildFlag = true;
            }
            loadQuery = loadQuery + "RNA_nucleotide_accession = ?";
        } else if ("RefSeqPro".equals(accnType)) {
            if (!accnID.contains(".")) {
                loadQuery = loadQuery + "protein_accession like (?) or ";
                wildFlag = true;
            }
            loadQuery = loadQuery + "protein_accession = ?";
        }
        log.println("LOAD: " + loadQuery);
        Connection con = null;
        PreparedStatement loadStmt = null;
        ResultSet rs = null;
        EntrezGene DBEntGene = null;
        try {
            con = DBUtil.getConnection();
            loadStmt = con.prepareStatement(loadQuery);
            int index = 1;
            if (speciesName != null) {
                int taxID = EntrezMirrorTables.getTaxID(speciesName);
                loadStmt.setInt(index++, taxID);
            }
            if (wildFlag) {
                loadStmt.setString(index++, accnID + ".%");
            }
            loadStmt.setString(index++, accnID);
            rs = loadStmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String[] tempArr;
                DBEntGene = new EntrezGene();
                if (speciesName != null) {
                    DBEntGene.setSpeciesName(speciesName);
                }
                DBEntGene.setID(rs.getString(GENE_ID_COL));
                if (!"-".equals(rs.getString(RNA_ACCN_COL))) {
                    tempArr = rs.getString(RNA_ACCN_COL).split("\\.");
                    DBEntGene.addRefSeqRNAID(tempArr[0]);
                }
                if (!"-".equals(rs.getString(PRO_ACCN_COL))) {
                    tempArr = rs.getString(PRO_ACCN_COL).split("\\.");
                    DBEntGene.addRefSeqRNAID(tempArr[0]);
                }
                EntrezMirrorTables.loadUniprot(DBEntGene);
                ++cnt;
            }
            if (cnt > 1) {
                System.err.println("More than one match for Entrez gene ID: " + accnID + " " + cnt);
            }
        }
        catch (SQLException e) {
            if (con != null && !con.isClosed()) {
                con.close();
            }
            throw e;
        }
        finally {
            if (loadStmt != null) {
                loadStmt.close();
            }
        }
        return DBEntGene;
    }

    public static ArrayList<String> getSpeciesCommonName(int taxID) throws SQLException {
        return EntrezMirrorTables.getSpeciesName("genbank common name", taxID);
    }

    public static ArrayList<String> getSpeciesScientificName(int taxID) throws SQLException {
        return EntrezMirrorTables.getSpeciesName("scientific name", taxID);
    }

    private static ArrayList<String> getSpeciesName(String speciesNameClass, int taxID) throws SQLException {
        if (taxID < 1) {
            throw new IllegalArgumentException("Invalid species ID: " + taxID);
        }
        String speciesNameQuery = "select *  from " + DBName + "." + TAX_NAMES_TABLE + " where " + TAX_ID_COL + " = ? and " + NAME_CLASS_COL + " = ? ";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> speciesNameList = new ArrayList<String>();
        try {
            con = DBUtil.getConnection();
            stmt = con.prepareStatement(speciesNameQuery);
            stmt.setInt(1, taxID);
            stmt.setString(2, speciesNameClass);
            rs = stmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                speciesNameList.add(rs.getString(NAME_COL));
                ++cnt;
            }
            if (cnt > 1 && speciesNameClass.equals("scientific name")) {
                System.err.println("Error: Duplicate scientific names for species" + taxID);
            }
        }
        catch (SQLException e) {
            if (con != null && !con.isClosed()) {
                con.close();
            }
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return speciesNameList;
    }

    static {
        log = GenUtil.getDefaultLog();
        DBName = DefParams.getDefaultProp("EntrezMirror");
    }
}

