package org.baderlab.pdzsvmstruct.utils;

import java.util.List;
import java.util.ArrayList;

import org.baderlab.pdzsvmstruct.data.Datum;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class KernelUtils
{

    public static double dot(double[] x, double[] y)
	{
		double sum = 0;
		int xlen = x.length;
		int ylen = y.length;
		if (xlen != ylen)
        {
            return -1;
        }
        for (int i = 0; i < x.length;i++)
		{
	        sum = sum + (x[i] * y[i]);
		}
		return sum;
	}

    public static double powi(double base, int times)
	{
	        double tmp = base, ret = 1.0;

        	for(int t=times; t>0; t/=2)
		{
                	if(t%2==1) ret*=tmp;
	                tmp = tmp * tmp;
        	}
	        return ret;
	}

    public static double rbf(double[] x, double[] y, double gamma)
    {
        double x_squared = dot(x,x);
        double y_squared = dot(y,y);
        return Math.exp(-gamma*(x_squared + y_squared - 2*dot(x,y)));
    }

    public static void main(String[] args)
    {
        double[] x = new double[]{1.0,3.0,1.0,3.0};
        double[] x2 = new double[]{-1.0,-3.0,-1.0,-3.0};
        System.out.println(KernelUtils.dot(x,x2));
    }
}
