package org.baderlab.pdzsvmstruct.utils;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Constants
 */
public class Constants
{

    public final static double MAX_SIM = 0.9;
    public final static double MAX_DOMAIN_SIM = 0.9;
    public final static double MAX_PEPTIDE_SIM =0.8;

    public final static String MOUSE_STRING = "Mus musculus (Mouse)";
    public final static String HUMAN_STRING = "Homo Sapiens (Human)";
    public final static String WORM_STRING = "Caenorhabditis elegans (nematode)";
    public final static String FLY_STRING = "Drosophila melanogaster (Fly)";
    public final static String HUMAN_MUTANT_STRING = "Homo Sapiens (Human) Mutant";

    public final static String PHAGE_DISPLAY_HIGH_STRING = "Phage Display High Valency";
    public final static String PHAGE_DISPLAY_LOW_STRING = "Phage Display Low Valency";
    public final static String PROTEIN_MICROARRAY_STRING = "Protein Microarray";
    public final static String PDZBASE_STRING ="PDZBase";
    public final static String ENSEMBL_STRING ="Ensembl";
    public final static String TAP = "Tap Experiment";

    public final static String RANDOM_PEPTIDE = "R";
    public final static String SHUFFLED_PEPTIDE = "S";
    public final static String HPRD ="HR";    
    public final static String PDZBASE ="PB";
    public final static String PHAGE_DISPLAY="PD";
    public final static String PROTEIN_MICROARRAY ="PM";
    public final static String ENSEMBL ="E";
    public final static String PEPTIDE_ARRAY = "PA";

    public final static String HUMAN ="H";
    public final static String HUMAN_REDUCED = "HR";
    public final static String MOUSE_REDUCED = "MR";
    public final static String HUMAN_MUTANT ="HMUT";
    public final static String HUMAN_POINT_MUTANT ="HMUT1";    
    public final static String HUMAN_10_MUTANT ="HMUT10";

    public final static String WORM ="W";
    public final static String FLY ="F";
    public final static String MOUSE ="M";
    public final static String STIFFLER_MOUSE = "SM";
    public final static String CHEN_MOUSE = "CM";
    public final static String MOUSE_ORPHAN = "MO";

    public final static String SIDHU_HUMAN = "SH";
    public final static String SIDHU_WORM_PDB = "SW";
    public final static String SIDHU_HUMAN_PDB = "HP";
    public final static String SIDHU_HUMAN_G_PDB = "HGP";
    public final static String SIDHU_HUMAN_NG_PDB = "HNGP";
    public final static String HOMOLOGY_MODEL = "HM";

    public final static String CHEN_MOUSE_PDB = "MP";
    public final static String CHEN_FLY_PDB = "FP";
    public final static String CHEN_WORM_PDB = "WP";
    public final static String CHEN_MOUSE_ORPHAN_PDB = "MOP";

    public final static String OSCHKINAT_HUMAN_PDB = "HO";
    public final static String HUMLIB="HB";
    public final static String SIDHU_WORM = "SW";
    public final static String NNK = "NNK";
    public final static String TAP_PSD95 = "TP";

    public final static int MIN_NUM_PEPTIDES = 10;
    public final static int NUM_RED_PEPTIDES = 3;
    public final static int NUM_RES_POS = 5;

    public final static String DATA_ROOT_DIR = "DATA_ROOT_DIR";
    public final static String CLASS_ROOT_DIR = "CLASS_ROOT_DIR";

    public final static int LIBSVM_FORMAT = 0;

    public final static String GENOMIC = "GENOMIC";
    public final static String NON_GENOMIC = "NON GENOMIC";
    public final static String BOTH = "BOTH";

    public static final String NONE = "NONE";
    public static final String PWM = "PWM";
    public static final String RANDOM = "RANDOM";
    public static final String SHUFFLED ="SHUFFLED";
    public static final String RANDOM_SEL = "RANDOM_SEL";


    public final static String  CLASS_YES = "Y";
    public final static String CLASS_NO= "N";

    public final static String[] CLASSES = new String[] {
            CLASS_YES,
            CLASS_NO
    };
}
