package org.baderlab.pdzsvmstruct.validation;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Cross validation parameters
 */
public class ValidationParameters {

    public final static int DOMAIN =0;
    public final static int PEPTIDE =1;
    public final static int DOMAIN_PEPTIDE =2;
    public final static int K_FOLD = 3;
    public final static int LOOV_DOMAIN = 4;
    public final static int LOOV_PEPTIDE = 5;
    public final static int LOSIM_DOMAIN = 6;
    public final static int ALLSIM_DOMAIN = 7;


    public final static String[] CV_STRING=new String[]{"Domain","Peptide","Domain-Peptide","KFold","LOOV-Domain","LOOV-Peptide","LOSim-Domain", "AllSim-Domain"};
    
    public int numTimes;
    public int k;
    public int d;
    public int p;
    public int type;
    public String outputDir;
    public String predictorName;
    public double sim = 0;
    public double[] simRange = new double[]{0,0};
    public int validationType;
    String dirName = "";
}
