package org.baderlab.pdzsvmstruct.utils;

import org.baderlab.pdzsvmstruct.utils.BindingSiteUtils;
import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;

import java.util.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class UniprotUtils {

    public UniprotUtils()
    {

    }

    public static HashMap getDomainNameToUniprotIdMap(String organism)
    {
        HashMap map = new HashMap();
        if (organism.equals(Constants.HUMAN))
        {
            try
            {
                String filename = DataFileManager.DATA_ROOT_DIR+"/Data/Uniprot/UniprotHuman.fa";
                BufferedReader br = new BufferedReader(new FileReader(new File(filename)));
                String line = "";
                while((line=br.readLine())!=null)
                {
                    if (line.startsWith(">"))
                    {
                        String[] splitLine = line.split("\\|");

                        String domainName = splitLine[0];
                        domainName = domainName.substring(1,domainName.length());
                        String uniprotId = splitLine[1];
                        map.put(domainName, uniprotId);
                    }
                }

                br.close();
            }
            catch(Exception e)
            {
                System.out.println("Exception: " + e);
            }
        }
        else if (organism.equals(Constants.MOUSE))
        {
            map.put("MAGI-2-6", "Q9WVQ1");
            map.put("CIPP-9", "Q63ZW7");
            map.put("DVL1-1", "P51141");
            map.put("ERBIN-1", "Q80TH2");
            map.put("LIN-7C-1", "O88952");
            map.put("SAP102-1", "P70175");
            map.put("SAP102-2", "P70175");
            map.put("MUPP1-10", "Q8VBX6");
            map.put("NHERF-1-1", "P70441");
            map.put("NHERF-2-1", "Q9JHL1");
            map.put("PDZ-RGS3-1", "Q9DC04");
            map.put("PDZK1-1", "Q9JIL4");
            map.put("PDZK1-3", "Q9JIL4");
            map.put("PSD95-2", "Q62108");
            map.put("PSD95-1", "Q62108");
            map.put("A1-SYNTROPHIN-1", "Q61234");
            map.put("LNX1-2", "O70263");
            map.put("NNOS-1", "Q9Z0J4");
        }
        return map;
    }
    public static HashMap getUniprotIDToSeqMap(String uniprotSeqFastaFileName)
    {
        HashMap map = new HashMap();
        try
        {

            BufferedReader br = new BufferedReader(new FileReader(new File(uniprotSeqFastaFileName)));
            String line = "";
            String uniprotID = "";
            String seq = "";
            while((line=br.readLine())!=null)
            {
                if (line.startsWith(">"))
                {
                    if(!uniprotID.equals(""))
                    {
                        //System.out.println(uniprotID +"\t" + seq);
                        map.put(uniprotID,seq);
                        seq = "";
                        
                    }
                    String[] splitLine = line.split("\\|");
                    uniprotID = splitLine[1];
                    //splitLine = line.split("\\s+");
                }
                else
                {
                    seq = seq+line;
                }

            }
            map.put(uniprotID,seq);
            //System.out.println(uniprotID +"\t" + seq);
            
            br.close();
        }
        catch(Exception e)
        {
            System.out.println("Exception: " + e);
        }
        return map;
    }
    public static void main(String[] args)
    {
        String uniprotToSeqfileName = DataFileManager.DATA_ROOT_DIR+"/Data/Uniprot/UniprotPDZDomainSeq.fasta";

        HashMap map = UniprotUtils.getUniprotIDToSeqMap(uniprotToSeqfileName);
        //HashMap map = UniprotUtils.getDomainNameToUniprotIdMap(Constants.HUMAN);
    }
}
