package org.baderlab.pdzsvmstruct.encoding;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;
import org.baderlab.pdzsvmstruct.utils.BindingSiteUtils;
import org.baderlab.pdzsvmstruct.utils.Constants;

import java.util.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class SurfvFeatureEncoding extends FeatureEncoding
{
    private HashMap domainNameToFileNameMap;
    private String surfvDir;
    private BindingSiteUtils bindingSite;
    private String organism;
    public SurfvFeatureEncoding(String organism)
    {
        setEncodingName("SURFV");

        this.organism= organism;
        bindingSite = new BindingSiteUtils(organism);
        if (organism.equals(Constants.HUMAN))
            surfvDir = DataFileManager.DATA_ROOT_DIR +"/Data/Human/PDZ/SURFV/";
        else if (organism.equals(Constants.MOUSE) ||
                organism.equals(Constants.MOUSE_ORPHAN))
            surfvDir = DataFileManager.DATA_ROOT_DIR +"/Data/Mouse/PDZ/SURFV/";
        else if (organism.equals(Constants.FLY))
            surfvDir = DataFileManager.DATA_ROOT_DIR +"/Data/Fly/PDZ/SURFV/";
        else if (organism.equals(Constants.WORM))
            surfvDir = DataFileManager.DATA_ROOT_DIR +"/Data/Worm/PDZ/SURFV/";
        initDomainNameToSurfvFileNameMap(organism);
        bindingSite = new BindingSiteUtils(organism);

    }
    public void initDomainNameToSurfvFileNameMap(String organism)
    {
        domainNameToFileNameMap = new HashMap();
        if (organism.equals(Constants.HUMAN))
        {
            domainNameToFileNameMap.put("CASK-1", "1KWA.res");
            domainNameToFileNameMap.put("DLG3-2","2FE5.res");
            //domainNameToFileNameMap.put("DVL2-1", "2REY.res");
            domainNameToFileNameMap.put("ERBB2IP-1", "1MFL.res");
            //domainNameToFileNameMap.put("MPDZ-1", "2O2T.res");
            domainNameToFileNameMap.put("MPDZ-1", "SWISSMODEL-MPDZ-1.res");

            domainNameToFileNameMap.put("MPDZ-10", "2OPG.res");
            //domainNameToFileNameMap.put("MPDZ-12", "2IWO.res");

            domainNameToFileNameMap.put("MPDZ-12", "SWISSMODEL-MPDZ-12.res");
            //domainNameToFileNameMap.put("MPDZ-13", "2FNE.res");
            //domainNameToFileNameMap.put("MPDZ-3", "2IWN.res");
            domainNameToFileNameMap.put("MPDZ-3", "SWISSMODEL-MPDZ-3.res");

            //domainNameToFileNameMap.put("PDLIM2-1", "2PA1.res");
            //domainNameToFileNameMap.put("PSCDBP-1", "2Z17.res");
            domainNameToFileNameMap.put("SCRIB-1", "2W4F.res");
            domainNameToFileNameMap.put("SLC9A3R2-2", "2HE4.res");
            domainNameToFileNameMap.put("DLG1-2", "2G2L.res");
            domainNameToFileNameMap.put("DLG4-3", "1TP3.res");
            domainNameToFileNameMap.put("PDLIM4-1", "2V1W.res");
            domainNameToFileNameMap.put("DLG2-3", "2HE2.res");
            domainNameToFileNameMap.put("INADL-2", "2DLU.res");
            domainNameToFileNameMap.put("SCRIB-2", "1WHA.res");

            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1.res");
            domainNameToFileNameMap.put("PDZK1-1", "SWISSMODEL-PDZK1-1.res");
          domainNameToFileNameMap.put("SHANK3-1", "SWISSMODEL-SHANK3-1.res");
            domainNameToFileNameMap.put("SNTA1-1", "SWISSMODEL-SNTA1-1.res");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.res");
          domainNameToFileNameMap.put("LRRC7-1", "SWISSMODEL-LRRC7-1.res");
            domainNameToFileNameMap.put("MPP6-1", "SWISSMODEL-MPP6-1.res");

            //domainNameToFileNameMap.put("APBA3-1", "2YT7.res");
            domainNameToFileNameMap.put("APBA3-1", "SWISSMODEL-APBA3-1.res");

            domainNameToFileNameMap.put("PSCDBP-1", "2Z17.res");
            domainNameToFileNameMap.put("MPDZ-7", "2IWQ.res");
            domainNameToFileNameMap.put("MPDZ-2", "SWISSMODEL-MPDZ-2.res");

             // PROTEOME SCANNING
            domainNameToFileNameMap.put("MPDZ-11","2QG1.res");
            domainNameToFileNameMap.put("MPDZ-13","2FNE.res");
            domainNameToFileNameMap.put("MPDZ-4", "SWISSMODEL-MPDZ-4.res");
            domainNameToFileNameMap.put("MPDZ-5", "SWISSMODEL-MPDZ-5.res");
            domainNameToFileNameMap.put("MPDZ-6", "SWISSMODEL-MPDZ-6.res");
            domainNameToFileNameMap.put("MPDZ-8", "SWISSMODEL-MPDZ-8.res");
            domainNameToFileNameMap.put("MPDZ-9", "SWISSMODEL-MPDZ-9.res");
            //domainNameToFileNameMap.put("INADL-1", "2DB5.res");
            //domainNameToFileNameMap.put("INADL-3", "2DMZ.res");
            domainNameToFileNameMap.put("INADL-5", "2D92.res");
            domainNameToFileNameMap.put("INADL-1", "SWISSMODEL-INADL-1.res");
            domainNameToFileNameMap.put("INADL-3", "SWISSMODEL-INADL-3.res");
            //domainNameToFileNameMap.put("INADL-5", "SWISSMODEL-INADL-5.res");
            domainNameToFileNameMap.put("INADL-6", "2EHR.res");
            domainNameToFileNameMap.put("INADL-7", "2DAZ.res");
            domainNameToFileNameMap.put("INADL-8", "2DM8.res");
            //domainNameToFileNameMap.put("INADL-7", "SWISSMODEL-INADL-7.res");
            //domainNameToFileNameMap.put("INADL-8", "SWISSMODEL-INADL-8.res");
            domainNameToFileNameMap.put("INADL-9", "SWISSMODEL-INADL-9.res");
            domainNameToFileNameMap.put("INADL-10", "SWISSMODEL-INADL-10.res");
            domainNameToFileNameMap.put("GRIP2-1", "SWISSMODEL-GRIP2-1.res");
            domainNameToFileNameMap.put("GRIP2-2", "SWISSMODEL-GRIP2-2.res");
            domainNameToFileNameMap.put("GRIP2-3", "1V62.res");
            domainNameToFileNameMap.put("GRIP2-4", "1X5R.res");
            domainNameToFileNameMap.put("GRIP2-5", "SWISSMODEL-GRIP2-5.res");
            domainNameToFileNameMap.put("GRIP2-6", "SWISSMODEL-GRIP2-6.res");
            domainNameToFileNameMap.put("GRIP2-7", "SWISSMODEL-GRIP2-7.res");
            domainNameToFileNameMap.put("SCRIB-3", "SWISSMODEL-SCRIB-3.res");
            domainNameToFileNameMap.put("SCRIB-4", "1UJU.res");
            domainNameToFileNameMap.put("GRIP1-1", "SWISSMODEL-GRIP1-1.res");
            domainNameToFileNameMap.put("GRIP1-2", "2JIL.res");
            domainNameToFileNameMap.put("GRIP1-3", "SWISSMODEL-GRIP1-3.res");
            domainNameToFileNameMap.put("GRIP1-4", "SWISSMODEL-GRIP1-4.res");
            domainNameToFileNameMap.put("GRIP1-5", "SWISSMODEL-GRIP1-5.res");
            domainNameToFileNameMap.put("GRIP1-6", "SWISSMODEL-GRIP1-6.res");
            domainNameToFileNameMap.put("GRIP1-7", "SWISSMODEL-GRIP1-7.res");
            domainNameToFileNameMap.put("PTPN13-1", "SWISSMODEL-PTPN13-1.res");
            domainNameToFileNameMap.put("PTPN13-3", "SWISSMODEL-PTPN13-3.res");
            domainNameToFileNameMap.put("PTPN13-4", "SWISSMODEL-PTPN13-4.res");
            domainNameToFileNameMap.put("PTPN13-5", "SWISSMODEL-PTPN13-5.res");
            
            //domainNameToFileNameMap.put("MAGI1-1", "SWISSMODEL-MAGI1-1.res");
            domainNameToFileNameMap.put("MAGI1-2", "2KPK.res");
            domainNameToFileNameMap.put("MAGI1-3", "SWISSMODEL-MAGI1-3.res");
            domainNameToFileNameMap.put("MAGI1-4", "SWISSMODEL-MAGI1-4.res");
            domainNameToFileNameMap.put("MAGI1-5", "SWISSMODEL-MAGI1-5.res");
            domainNameToFileNameMap.put("MAGI1-6", "SWISSMODEL-MAGI1-6.res");

            domainNameToFileNameMap.put("MAGI2-1", "SWISSMODEL-MAGI2-1.res");
            domainNameToFileNameMap.put("MAGI2-2", "1UEQ.res");
            domainNameToFileNameMap.put("MAGI2-3", "SWISSMODEL-MAGI2-3.res"); // *
            domainNameToFileNameMap.put("MAGI2-4", "1UEP.res");
            domainNameToFileNameMap.put("MAGI2-5", "SWISSMODEL-MAGI2-5.res");
            domainNameToFileNameMap.put("MAGI2-6", "1WFV.res");

            //domainNameToFileNameMap.put("MAGI3-1", "SWISSMODEL-MAGI3-1.res");
            domainNameToFileNameMap.put("MAGI3-2", "SWISSMODEL-MAGI3-2.res");
            domainNameToFileNameMap.put("MAGI3-3", "SWISSMODEL-MAGI3-3.res");
            domainNameToFileNameMap.put("MAGI3-4", "SWISSMODEL-MAGI3-4.res");
            domainNameToFileNameMap.put("MAGI3-5", "SWISSMODEL-MAGI3-5.res");
            domainNameToFileNameMap.put("MAGI3-6", "SWISSMODEL-MAGI3-6.res");

            //domainNameToFileNameMap.put("PDZD2-1", "SWISSMODEL-PDZD2-1.res");
            domainNameToFileNameMap.put("PDZD2-2", "SWISSMODEL-PDZD2-2.res");
            domainNameToFileNameMap.put("PDZD2-3", "SWISSMODEL-PDZD2-3.res");
            domainNameToFileNameMap.put("PDZD2-4", "SWISSMODEL-PDZD2-4.res");
            domainNameToFileNameMap.put("PDZD2-5", "SWISSMODEL-PDZD2-5.res");
            //domainNameToFileNameMap.put("PDZD2-6", "SWISSMODEL-PDZD2-6.res");
            
            domainNameToFileNameMap.put("DLG4-1", "SWISSMODEL-DLG4-1.res");
            domainNameToFileNameMap.put("DLG4-2", "SWISSMODEL-DLG4-2.res");
            domainNameToFileNameMap.put("DLG2-1", "SWISSMODEL-DLG2-1.res");
            //domainNameToFileNameMap.put("DLG2-2", "2BYG.res");
            domainNameToFileNameMap.put("DLG2-2", "SWISSMODEL-DLG2-2.res");
            //domainNameToFileNameMap.put("LNX2-1", "SWISSMODEL-LNX2-1");
            //domainNameToFileNameMap.put("LNX2-2", "2VWR-LNX2-2");
            //domainNameToFileNameMap.put("LNX2-3", "SWISSMODEL-LNX2-3");
            //domainNameToFileNameMap.put("LNX2-4", "SWISSMODEL-LNX2-4");

            domainNameToFileNameMap.put("DLG3-1", "2I1N.res");
            domainNameToFileNameMap.put("DLG3-3", "1UM7.res");
             //domainNameToFileNameMap.put("LNX2-1", "SWISSMODEL-LNX2-1");
            //domainNameToFileNameMap.put("LNX2-2", "2VWR-LNX2-2");
            //domainNameToFileNameMap.put("LNX2-3", "SWISSMODEL-LNX2-3");
            //domainNameToFileNameMap.put("LNX2-4", "SWISSMODEL-LNX2-4");
            domainNameToFileNameMap.put("DLG3-1", "2I1N.res");
            domainNameToFileNameMap.put("DLG3-3", "1UM7.res");
            //domainNameToFileNameMap.put("LNX1-1", "SWISSMODEL-LNX1-1");
            //domainNameToFileNameMap.put("LNX1-2", "SWISSMODEL-LNX1-2");
            //domainNameToFileNameMap.put("LNX1-3", "SWISSMODEL-LNX1-3");
            //domainNameToFileNameMap.put("LNX1-4", "SWISSMODEL-LNX1-4");
            domainNameToFileNameMap.put("PDZK1-2", "2EEI.res");
            domainNameToFileNameMap.put("PDZK1-3", "SWISSMODEL-PDZK1-3.res");
            //domainNameToFileNameMap.put("PDZK1-4", "2VSP-PDZK1-4");
            domainNameToFileNameMap.put("TJP1-1", "2H2C.res");
            domainNameToFileNameMap.put("TJP1-2", "2RCZ.res");
            domainNameToFileNameMap.put("TJP1-3", "SWISSMODEL-TJP1-3.res");
            domainNameToFileNameMap.put("PDZD3-1", "SWISSMODEL-PDZD3-1.res");
            domainNameToFileNameMap.put("PDZD3-2", "SWISSMODEL-PDZD3-2.res");
            //domainNameToFileNameMap.put("PDZD3-3", "2V90.res");
            domainNameToFileNameMap.put("PDZD3-3", "SWISSMODEL-PDZD3-3.res");
            //domainNameToFileNameMap.put("PDZD3-4", "SWISSMODEL-PDZD3-4");
            domainNameToFileNameMap.put("IL16-1", "SWISSMODEL-IL16-1.res");
            //domainNameToFileNameMap.put("IL16-2", "SWISSMODEL-IL16-2");
            //domainNameToFileNameMap.put("IL16-3", "1X6D-IL16-3");
            ///domainNameToFileNameMap.put("IL16-4", "1I16-IL16-4");
            domainNameToFileNameMap.put("TJP2-1", "2CSJ.res");
            domainNameToFileNameMap.put("TJP2-2", "3E17.res");
            domainNameToFileNameMap.put("TJP2-3", "SWISSMODEL-TJP2-3.res");
            domainNameToFileNameMap.put("WHRN-1", "1UEZ.res");
            domainNameToFileNameMap.put("WHRN-2", "1UF1.res");
            //domainNameToFileNameMap.put("WHRN-2", "SWISSMODEL-WHRN-2.res");
            //domainNameToFileNameMap.put("WHRN-3", "1UFX-WHRN-3");
            domainNameToFileNameMap.put("TJP3-1", "SWISSMODEL-TJP3-1.res");
            domainNameToFileNameMap.put("TJP3-2", "SWISSMODEL-TJP3-2.res");
            domainNameToFileNameMap.put("FRMPD2-1", "SWISSMODEL-FRMPD2-1.res");
            domainNameToFileNameMap.put("FRMPD2-2", "SWISSMODEL-FRMPD2-2.res");
            domainNameToFileNameMap.put("FRMPD2-3", "SWISSMODEL-FRMPD2-3.res");
            ///domainNameToFileNameMap.put("DLG5-1", "SWISSMODEL-DLG5-1");
            //domainNameToFileNameMap.put("DLG5-2", "SWISSMODEL-DLG5-2");
            domainNameToFileNameMap.put("DLG5-3", "1UIT.res");
            domainNameToFileNameMap.put("DLG5-4", "SWISSMODEL-DLG5-4.res");
            domainNameToFileNameMap.put("SLC9A3R1-1", "1G9O.res");
            //domainNameToFileNameMap.put("SLC9A3R1-2", "2KJD.res");
            domainNameToFileNameMap.put("SLC9A3R1-2", "SWISSMODEL-SLC9A3R1-2.res");
            domainNameToFileNameMap.put("DVL1-1", "SWISSMODEL-DVL1-1.res");
            //domainNameToFileNameMap.put("SYNJ2BP-1", "2JIN-SYNJ2BP-1");
            domainNameToFileNameMap.put("DVL1L1-1", "SWISSMODEL-DVL1L1-1.res");
            domainNameToFileNameMap.put("LIN7B-1", "2DKR.res");
            //domainNameToFileNameMap.put("LIN7B-1", "SWISSMODEL-LIN7B-1.res");
            domainNameToFileNameMap.put("LIN7C-1", "SWISSMODEL-LIN7C-1.res");
            domainNameToFileNameMap.put("LIN7A-1", "SWISSMODEL-LIN7A-1.res");
            domainNameToFileNameMap.put("DVL3-1", "SWISSMODEL-DVL3-1.res");
            domainNameToFileNameMap.put("PTPN4-1", "2CS5.res");
            domainNameToFileNameMap.put("SNTB2-1", "2VRF.res");
            domainNameToFileNameMap.put("DVL2-1", "2REY.res");
            domainNameToFileNameMap.put("MPP1-1", "2EV8.res");
            //domainNameToFileNameMap.put("TAX1BP3-1", "3GJ9-TAX1BP3-1");
            domainNameToFileNameMap.put("PDLIM1-1", "2PKT.res");
            domainNameToFileNameMap.put("PTPN3-1", "SWISSMODEL-PTPN3-1.res");
            domainNameToFileNameMap.put("PDZD11-1", "SWISSMODEL-PDZD11-1.res");
            domainNameToFileNameMap.put("PDZD4-1", "SWISSMODEL-PDZD4-1.res");
            domainNameToFileNameMap.put("GOPC-1", "2DC2.res");
            domainNameToFileNameMap.put("FRMPD2P1-1", "SWISSMODEL-FRMPD2P1-1.res");
            domainNameToFileNameMap.put("LIMK2-1", "SWISSMODEL-LIMK2-1.res");
            domainNameToFileNameMap.put("SNTG2-1", "SWISSMODEL-SNTG2-1.res");
            domainNameToFileNameMap.put("SNTB1-1", "SWISSMODEL-SNTB1-1.res");
            domainNameToFileNameMap.put("NOS1-1", "1QAV.res");
            domainNameToFileNameMap.put("SNTG1-1", "SWISSMODEL-SNTG1-1.res");
            //domainNameToFileNameMap.put("MLLT4-1", "1T2M.res");
            domainNameToFileNameMap.put("MLLT4-1", "SWISSMODEL-MLLT4-1.res");

            domainNameToFileNameMap.put("LIMK1-1", "SWISSMODEL-LIMK1-1.res");
            domainNameToFileNameMap.put("PDLIM3-1", "SWISSMODEL-PDLIM3-1.res");
            domainNameToFileNameMap.put("SDCBP2-1", "SWISSMODEL-SDCBP2-1.res");
            domainNameToFileNameMap.put("SDCBP2-2", "SWISSMODEL-SDCBP2-2.res");
            domainNameToFileNameMap.put("LDB3-1", "1RGW.res");
            domainNameToFileNameMap.put("PDLIM2-1", "2PA1.res");
            domainNameToFileNameMap.put("MPP7-1", "3O46.res");
            //domainNameToFileNameMap.put("ARHGEF11-1", "2DLS.res");
            domainNameToFileNameMap.put("ARHGEF11-1", "SWISSMODEL-ARHGEF11-1.res");
            domainNameToFileNameMap.put("PDLIM5-1", "2UZC.res");
            domainNameToFileNameMap.put("RAPGEF6-1", "SWISSMODEL-RAPGEF6-1.res");
            //domainNameToFileNameMap.put("CYTIP-1", "2Z17-CYTIP-1");
            //domainNameToFileNameMap.put("PPP1R9A-1", "1WF8.res");
            domainNameToFileNameMap.put("PPP1R9A-1", "SWISSMODEL-PPP1R9A-1.res");
            domainNameToFileNameMap.put("RGS12-1", "2KV8.res");
            domainNameToFileNameMap.put("PPP1R9B-1", "3EGG.res");
            domainNameToFileNameMap.put("RHPN1-1", "SWISSMODEL-RHPN1-1.res");
            domainNameToFileNameMap.put("GRASP-1", "2PNT.res");
            domainNameToFileNameMap.put("ARHGEF12-1", "2OS6.res");
            domainNameToFileNameMap.put("PDLIM7-1", "2Q3G.res");
            domainNameToFileNameMap.put("MPP3-1", "SWISSMODEL-MPP3-1.res");
            domainNameToFileNameMap.put("MPP5-1", "1VA8.res");
            domainNameToFileNameMap.put("PARD6B-1", "1NF3.res");
            domainNameToFileNameMap.put("SYNPO2L-1", "SWISSMODEL-SYNPO2L-1.res");
            domainNameToFileNameMap.put("MPP4-1", "SWISSMODEL-MPP4-1.res");
            domainNameToFileNameMap.put("RADIL-1", "1UM1.res");
            domainNameToFileNameMap.put("USH1C-1", "SWISSMODEL-USH1C-1.res");
            domainNameToFileNameMap.put("USH1C-2", "SWISSMODEL-USH1C-2.res");
            domainNameToFileNameMap.put("USH1C-3", "SWISSMODEL-USH1C-3.res");
            domainNameToFileNameMap.put("PDZK1P1-1", "SWISSMODEL-PDZK1P1-1.res");
            domainNameToFileNameMap.put("PDZK1P1-2", "SWISSMODEL-PDZK1P1-2.res");
            //domainNameToFileNameMap.put("PDZK1P1-3", "2VSP-PDZK1P1-3");
            domainNameToFileNameMap.put("PARD3-1", "SWISSMODEL-PARD3-1.res");
            //domainNameToFileNameMap.put("PARD3-2", "2KOM-PARD3-2");
            domainNameToFileNameMap.put("PARD3-3", "SWISSMODEL-PARD3-3.res");
            domainNameToFileNameMap.put("PARD3B-1", "SWISSMODEL-PARD3B-1.res");
            domainNameToFileNameMap.put("PARD3B-2", "SWISSMODEL-PARD3B-2.res");
            domainNameToFileNameMap.put("PARD3B-3", "SWISSMODEL-PARD3B-3.res");
            domainNameToFileNameMap.put("PDZD7-1", "2EEH.res");
            //domainNameToFileNameMap.put("PDZD7-2", "SWISSMODEL-PDZD7-2");
            domainNameToFileNameMap.put("PDZRN4-1", "SWISSMODEL-PDZRN4-1.res");
            domainNameToFileNameMap.put("PDZRN4-2", "SWISSMODEL-PDZRN4-2.res");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "2OCS-SLC9A3R2-1");
            domainNameToFileNameMap.put("APBA2-1", "SWISSMODEL-APBA2-1.res");
            domainNameToFileNameMap.put("APBA2-2", "SWISSMODEL-APBA2-2.res");
            //domainNameToFileNameMap.put("APBA3-1", "2YT7.res");
            domainNameToFileNameMap.put("APBA3-2", "2YT8.res");
            domainNameToFileNameMap.put("PDZRN3-1", "1UHP.res");
            //domainNameToFileNameMap.put("PDZRN3-2", "1WH1-PDZRN3-2");
            //domainNameToFileNameMap.put("APBA1-1", "1U37-APBA1-1");
            //domainNameToFileNameMap.put("APBA1-2", "1U39-APBA1-2");
            domainNameToFileNameMap.put("PARD6G-1", "SWISSMODEL-PARD6G-1.res");
            domainNameToFileNameMap.put("GIPC2-1", "3GGE.res");
            domainNameToFileNameMap.put("PARD6A-1", "SWISSMODEL-PARD6A-1.res");
            //domainNameToFileNameMap.put("RIMS1-1", "2CSS.res");
            domainNameToFileNameMap.put("CNKSR3-1", "SWISSMODEL-CNKSR3-1.res");
            domainNameToFileNameMap.put("PICK1-1", "2GZV.res");
            //domainNameToFileNameMap.put("STXBP4-1", "SWISSMODEL-STXBP4-1");
            domainNameToFileNameMap.put("FRMPD4-1", "SWISSMODEL-FRMPD4-1.res");
            domainNameToFileNameMap.put("SHROOM2-1", "SWISSMODEL-SHROOM2-1.res");
            domainNameToFileNameMap.put("SYNPO2-1", "SWISSMODEL-SYNPO2-1.res");
            //domainNameToFileNameMap.put("FRMPD3-1", "SWISSMODEL-FRMPD3-1");
            domainNameToFileNameMap.put("MAST1-1", "3PS4.res");
            domainNameToFileNameMap.put("SIPA1-1", "SWISSMODEL-SIPA1-1.res");
            //domainNameToFileNameMap.put("SHANK1-1", "SWISSMODEL-SHANK1-1");
            domainNameToFileNameMap.put("CNKSR2-1", "SWISSMODEL-CNKSR2-1.res");
            domainNameToFileNameMap.put("SHROOM3-1", "SWISSMODEL-SHROOM3-1.res");
            //domainNameToFileNameMap.put("MPP2-1", "2E7K.res");
            domainNameToFileNameMap.put("MPP2-1", "SWISSMODEL-MPP2-1.res");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1.res");
            domainNameToFileNameMap.put("MYO18A-1", "SWISSMODEL-MYO18A-1.res");
            //domainNameToFileNameMap.put("FRMPD1-1", "2EDV.res");
            domainNameToFileNameMap.put("FRMPD1-1", "SWISSMODEL-FRMPD1-1.res");
            //domainNameToFileNameMap.put("PDZD8-1", "SWISSMODEL-PDZD8-1");
            domainNameToFileNameMap.put("TIAM1-1", "2D8I.res");
            domainNameToFileNameMap.put("GIPC1-1", "SWISSMODEL-GIPC1-1.res");
            domainNameToFileNameMap.put("GIPC3-1", "SWISSMODEL-GIPC3-1.res");
            //domainNameToFileNameMap.put("RGS3-1", "2F5Y.res");
            domainNameToFileNameMap.put("RGS3-1", "SWISSMODEL-RGS3-1.res");
            //domainNameToFileNameMap.put("RIMS2-1", "1WFG-RIMS2-1");
            domainNameToFileNameMap.put("SHROOM4-1", "2EDP.res");
            domainNameToFileNameMap.put("SIPA1L2-1", "SWISSMODEL-SIPA1L2-1.res");
            domainNameToFileNameMap.put("SIPA1L1-1", "SWISSMODEL-SIPA1L1-1.res");
            domainNameToFileNameMap.put("SIPA1L3-1", "SWISSMODEL-SIPA1L3-1.res");
            domainNameToFileNameMap.put("RHPN2-1", "2VSV.res");

            domainNameToFileNameMap.put("RIMS1-1", "SWISSMODEL-RIMS1-1.res");
            //domainNameToFileNameMap.put("RIMS2-1", "SWISSMODEL-RIMS2-1.res");
            //domainNameToFileNameMap.put("PDZRN3-2", "SWISSMODEL-PDZRN3-2.res");
            domainNameToFileNameMap.put("APBA1-1", "SWISSMODEL-APBA1-1.res");
            domainNameToFileNameMap.put("APBA1-2", "SWISSMODEL-APBA1-2.res");
            //domainNameToFileNameMap.put("PARD3-2", "SWISSMODEL-PARD3-2.res");
            //domainNameToFileNameMap.put("CYTIP-1", "SWISSMODEL-CYTIP-1.res");
            //domainNameToFileNameMap.put("TAX1BP3-1", "SWISSMODEL-TAX1BP3-1.res");
            domainNameToFileNameMap.put("SYNJ2BP-1", "SWISSMODEL-SYNJ2BP-1.res");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1.res");
            //domainNameToFileNameMap.put("IL16-4", "SWISSMODEL-IL16-4.res");
            domainNameToFileNameMap.put("GRD2I-1", "SWISSMODEL-GRD2I-1.res");            
            domainNameToFileNameMap.put("GRD2I-2", "SWISSMODEL-GRD2I-2.res");
            domainNameToFileNameMap.put("GORS1-1", "SWISSMODEL-GORS1-1.res");
            domainNameToFileNameMap.put("TJP3-3", "SWISSMODEL-TJP3-3.res");
            domainNameToFileNameMap.put("SDCBP-1", "1YBO.res");            
            domainNameToFileNameMap.put("SDCBP-2", "SWISSMODEL-SDCBP-2.res");
            //domainNameToFileNameMap.put("CAR11-1", "SWISSMODEL-CAR11-1");
            domainNameToFileNameMap.put("CAR14-1", "SWISSMODEL-CAR14-1.res");
            domainNameToFileNameMap.put("HTRA2-1", "SWISSMODEL-HTRA2-1.res");
            domainNameToFileNameMap.put("MAST2-1", "SWISSMODEL-MAST2-1.res");
            domainNameToFileNameMap.put("MAST3-1", "SWISSMODEL-MAST3-1.res");
            //domainNameToFileNameMap.put("RPGF2-1", "SWISSMODEL-RPGF2-1");
            domainNameToFileNameMap.put("CNKR1-1", "SWISSMODEL-CNKR1-1.res");
            domainNameToFileNameMap.put("GRIP2-4", "SWISSMODEL-GRIP2-4.res");
            domainNameToFileNameMap.put("IL16-3", "SWISSMODEL-IL16-3.res");
            domainNameToFileNameMap.put("PTPN13-2", "SWISSMODEL-PTPN13-2.res");
            domainNameToFileNameMap.put("WHRN-3", "SWISSMODEL-WHRN-3.res");
            //domainNameToFileNameMap.put("SLC9A3R2-1", "SWISSMODEL-SLC9A3R2-1");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4.res");
            domainNameToFileNameMap.put("ARHGEF12-1", "SWISSMODEL-ARHGEF12-1.res");
            /*domainNameToFileNameMap.put("R49A-1", "SWISSMODEL-ERBINMUT-R49A.res");
            domainNameToFileNameMap.put("R49C-1", "SWISSMODEL-ERBINMUT-R49C.res");
            domainNameToFileNameMap.put("R49F-1", "SWISSMODEL-ERBINMUT-R49F.res");
            domainNameToFileNameMap.put("R49W-1", "SWISSMODEL-ERBINMUT-R49W.res");
            domainNameToFileNameMap.put("R49Y-1", "SWISSMODEL-ERBINMUT-R49Y.res");

            domainNameToFileNameMap.put("E-27-1", "SWISSMODEL-ERBINMUT10-E27-C8.res");
            domainNameToFileNameMap.put("E-12-1", "SWISSMODEL-ERBINMUT10-E12-B2.res");
            domainNameToFileNameMap.put("E-43-1", "SWISSMODEL-ERBINMUT10-E43-E11.res");
            domainNameToFileNameMap.put("E-2-1", "SWISSMODEL-ERBINMUT10-E2-A2.res");
            domainNameToFileNameMap.put("E-20-1", "SWISSMODEL-ERBINMUT10-E20-B12.res");
            domainNameToFileNameMap.put("E-14-1", "SWISSMODEL-ERBINMUT10-E14-B4.res");
            domainNameToFileNameMap.put("E-30-1", "SWISSMODEL-ERBINMUT10-E30-C12.res");
            domainNameToFileNameMap.put("E-31-1", "SWISSMODEL-ERBINMUT10-E31-D2.res");
            domainNameToFileNameMap.put("E-32-1", "SWISSMODEL-ERBINMUT10-E32-D3.res");
            domainNameToFileNameMap.put("E-33-1", "SWISSMODEL-ERBINMUT10-E33-D4.res");
            domainNameToFileNameMap.put("E-44-1", "SWISSMODEL-ERBINMUT10-E44-F1.res");
            domainNameToFileNameMap.put("E-57-1", "SWISSMODEL-ERBINMUT10-E57-G8.res");
            domainNameToFileNameMap.put("E-58-1", "SWISSMODEL-ERBINMUT10-E58-G9.res");

            domainNameToFileNameMap.put("E-8-1", "SWISSMODEL-ERBINMUT10-E8-A10.res");
            domainNameToFileNameMap.put("E-9-1", "SWISSMODEL-ERBINMUT10-E9-A11.res");
            domainNameToFileNameMap.put("E-10-1", "SWISSMODEL-ERBINMUT10-E10-A12.res");
            domainNameToFileNameMap.put("E-4-1", "SWISSMODEL-ERBINMUT10-E4-A5.res");
            domainNameToFileNameMap.put("E-7-1", "SWISSMODEL-ERBINMUT10-E7-A9.res");
            domainNameToFileNameMap.put("E-13-1", "SWISSMODEL-ERBINMUT10-E13-B3.res");
            domainNameToFileNameMap.put("E-16-1", "SWISSMODEL-ERBINMUT10-E16-B6.res");
            domainNameToFileNameMap.put("E-29-1", "SWISSMODEL-ERBINMUT10-E29-C11.res");
            domainNameToFileNameMap.put("E-24-1", "SWISSMODEL-ERBINMUT10-E24-C4.res");
            domainNameToFileNameMap.put("E-28-1", "SWISSMODEL-ERBINMUT10-E28-C9.res");
            domainNameToFileNameMap.put("E-38-1", "SWISSMODEL-ERBINMUT10-E38-E4.res");
            domainNameToFileNameMap.put("E-39-1", "SWISSMODEL-ERBINMUT10-E39-E6.res");
            domainNameToFileNameMap.put("E-49-1", "SWISSMODEL-ERBINMUT10-E49-F10.res");
            domainNameToFileNameMap.put("E-50-1", "SWISSMODEL-ERBINMUT10-E50-F11.res");
            domainNameToFileNameMap.put("E-51-1", "SWISSMODEL-ERBINMUT10-E51-F12.res");
            domainNameToFileNameMap.put("E-61-1", "SWISSMODEL-ERBINMUT10-E61-G12.res");
            domainNameToFileNameMap.put("E-54-1", "SWISSMODEL-ERBINMUT10-E54-G4.res");
            domainNameToFileNameMap.put("E-56-1", "SWISSMODEL-ERBINMUT10-E56-G6.res");

            domainNameToFileNameMap.put("E-5-1", "SWISSMODEL-ERBINMUT10-E5-A6.res");
            domainNameToFileNameMap.put("E-6-1", "SWISSMODEL-ERBINMUT10-E6-A7.res");
            domainNameToFileNameMap.put("E-19-1", "SWISSMODEL-ERBINMUT10-E19-B10.res");
            domainNameToFileNameMap.put("E-11-1", "SWISSMODEL-ERBINMUT10-E11-B1.res");
            domainNameToFileNameMap.put("E-17-1", "SWISSMODEL-ERBINMUT10-E17-B7.res");
            domainNameToFileNameMap.put("E-18-1", "SWISSMODEL-ERBINMUT10-E18-B9.res");
            domainNameToFileNameMap.put("E-22-1", "SWISSMODEL-ERBINMUT10-E22-C2.res");
            domainNameToFileNameMap.put("E-23-1", "SWISSMODEL-ERBINMUT10-E23-C3.res");
            domainNameToFileNameMap.put("E-36-1", "SWISSMODEL-ERBINMUT10-E36-D11.res");
            domainNameToFileNameMap.put("E-42-1", "SWISSMODEL-ERBINMUT10-E42-E10.res");
            domainNameToFileNameMap.put("E-37-1", "SWISSMODEL-ERBINMUT10-E37-E3.res");
            domainNameToFileNameMap.put("E-41-1", "SWISSMODEL-ERBINMUT10-E41-E8.res");
            domainNameToFileNameMap.put("E-46-1", "SWISSMODEL-ERBINMUT10-E46-F6.res");
            domainNameToFileNameMap.put("E-47-1", "SWISSMODEL-ERBINMUT10-E47-F7.res");
            domainNameToFileNameMap.put("E-48-1", "SWISSMODEL-ERBINMUT10-E48-F9.res");
            domainNameToFileNameMap.put("E-59-1", "SWISSMODEL-ERBINMUT10-E59-G10.res");
            domainNameToFileNameMap.put("E-52-1", "SWISSMODEL-ERBINMUT10-E52-G2.res");
            domainNameToFileNameMap.put("E-53-1", "SWISSMODEL-ERBINMUT10-E53-G3.res");
            domainNameToFileNameMap.put("E-55-1", "SWISSMODEL-ERBINMUT10-E55-G5.res");

            domainNameToFileNameMap.put("E-15-1", "SWISSMODEL-ERBINMUT10-E15-B5.res");
            domainNameToFileNameMap.put("E-26-1", "SWISSMODEL-ERBINMUT10-E26-C7.res");
            domainNameToFileNameMap.put("E-34-1", "SWISSMODEL-ERBINMUT10-E34-D7.res");
            domainNameToFileNameMap.put("E-35-1", "SWISSMODEL-ERBINMUT10-E35-D9.res");
            domainNameToFileNameMap.put("E-40-1", "SWISSMODEL-ERBINMUT10-E40-E7.res");
            domainNameToFileNameMap.put("E-45-1", "SWISSMODEL-ERBINMUT10-E45-F5.res");
            domainNameToFileNameMap.put("E-60-1", "SWISSMODEL-ERBINMUT10-E60-G11.res");
            
            domainNameToFileNameMap.put("E-1-1", "SWISSMODEL-ERBINMUT10-E1-A1.res");
            domainNameToFileNameMap.put("E-3-1", "SWISSMODEL-ERBINMUT10-E3-A4.res");
            domainNameToFileNameMap.put("E-21-1", "SWISSMODEL-ERBINMUT10-E21-C1.res");
            domainNameToFileNameMap.put("E-25-1", "SWISSMODEL-ERBINMUT10-E25-C6.res");

            domainNameToFileNameMap.put("F25I-1","SWISSMODEL-ERBINMUT-F25I.res");
            domainNameToFileNameMap.put("F25L-1","SWISSMODEL-ERBINMUT-F25L.res");
            domainNameToFileNameMap.put("F25V-1","SWISSMODEL-ERBINMUT-F25V.res");
            domainNameToFileNameMap.put("H79A-1","SWISSMODEL-ERBINMUT-H79A.res");
            domainNameToFileNameMap.put("H79C-1","SWISSMODEL-ERBINMUT-H79C.res");
            domainNameToFileNameMap.put("H79D-1","SWISSMODEL-ERBINMUT-H79D.res");
            domainNameToFileNameMap.put("H79E-1","SWISSMODEL-ERBINMUT-H79E.res");
            domainNameToFileNameMap.put("H79F-1","SWISSMODEL-ERBINMUT-H79F.res");
            domainNameToFileNameMap.put("H79I-1","SWISSMODEL-ERBINMUT-H79I.res");
            domainNameToFileNameMap.put("H79K-1","SWISSMODEL-ERBINMUT-H79K.res");
            domainNameToFileNameMap.put("H79L-1","SWISSMODEL-ERBINMUT-H79L.res");
            domainNameToFileNameMap.put("H79M-1","SWISSMODEL-ERBINMUT-H79M.res");
            domainNameToFileNameMap.put("H79N-1","SWISSMODEL-ERBINMUT-H79N.res");
            domainNameToFileNameMap.put("H79P-1","SWISSMODEL-ERBINMUT-H79P.res");
            domainNameToFileNameMap.put("H79Q-1","SWISSMODEL-ERBINMUT-H79Q.res");
            domainNameToFileNameMap.put("H79R-1","SWISSMODEL-ERBINMUT-H79R.res");
            domainNameToFileNameMap.put("H79S-1","SWISSMODEL-ERBINMUT-H79S.res");
            domainNameToFileNameMap.put("H79T-1","SWISSMODEL-ERBINMUT-H79T.res");
            domainNameToFileNameMap.put("H79V-1","SWISSMODEL-ERBINMUT-H79V.res");
            domainNameToFileNameMap.put("H79W-1","SWISSMODEL-ERBINMUT-H79W.res");
            domainNameToFileNameMap.put("H79Y-1","SWISSMODEL-ERBINMUT-H79Y.res");
            domainNameToFileNameMap.put("I27L-1","SWISSMODEL-ERBINMUT-I27L.res");
            domainNameToFileNameMap.put("I27V-1","SWISSMODEL-ERBINMUT-I27V.res");
            domainNameToFileNameMap.put("L23F-1","SWISSMODEL-ERBINMUT-L23F.res");
            domainNameToFileNameMap.put("L23I-1","SWISSMODEL-ERBINMUT-L23I.res");
            domainNameToFileNameMap.put("L23V-1","SWISSMODEL-ERBINMUT-L23V.res");
            domainNameToFileNameMap.put("Q51A-1","SWISSMODEL-ERBINMUT-Q51A.res");
            domainNameToFileNameMap.put("Q51D-1","SWISSMODEL-ERBINMUT-Q51D.res");
            domainNameToFileNameMap.put("Q51E-1","SWISSMODEL-ERBINMUT-Q51E.res");
            domainNameToFileNameMap.put("Q51G-1","SWISSMODEL-ERBINMUT-Q51G.res");
            domainNameToFileNameMap.put("Q51H-1","SWISSMODEL-ERBINMUT-Q51H.res");
            domainNameToFileNameMap.put("Q51I-1","SWISSMODEL-ERBINMUT-Q51I.res");
            domainNameToFileNameMap.put("Q51K-1","SWISSMODEL-ERBINMUT-Q51K.res");
            domainNameToFileNameMap.put("Q51L-1","SWISSMODEL-ERBINMUT-Q51L.res");
            domainNameToFileNameMap.put("Q51M-1","SWISSMODEL-ERBINMUT-Q51M.res");
            domainNameToFileNameMap.put("Q51N-1","SWISSMODEL-ERBINMUT-Q51N.res");
            domainNameToFileNameMap.put("Q51P-1","SWISSMODEL-ERBINMUT-Q51P.res");
            domainNameToFileNameMap.put("Q51R-1","SWISSMODEL-ERBINMUT-Q51R.res");
            domainNameToFileNameMap.put("Q51S-1","SWISSMODEL-ERBINMUT-Q51S.res");
            domainNameToFileNameMap.put("Q51T-1","SWISSMODEL-ERBINMUT-Q51T.res");
            domainNameToFileNameMap.put("Q51V-1","SWISSMODEL-ERBINMUT-Q51V.res");
            domainNameToFileNameMap.put("R49A-1","SWISSMODEL-ERBINMUT-R49A.res");
            domainNameToFileNameMap.put("R49C-1","SWISSMODEL-ERBINMUT-R49C.res");
            domainNameToFileNameMap.put("R49D-1","SWISSMODEL-ERBINMUT-R49D.res");
            domainNameToFileNameMap.put("R49E-1","SWISSMODEL-ERBINMUT-R49E.res");
            domainNameToFileNameMap.put("R49F-1","SWISSMODEL-ERBINMUT-R49F.res");
            domainNameToFileNameMap.put("R49G-1","SWISSMODEL-ERBINMUT-R49G.res");
            domainNameToFileNameMap.put("R49H-1","SWISSMODEL-ERBINMUT-R49H.res");
            domainNameToFileNameMap.put("R49I-1","SWISSMODEL-ERBINMUT-R49I.res");
            domainNameToFileNameMap.put("R49K-1","SWISSMODEL-ERBINMUT-R49K.res");
            domainNameToFileNameMap.put("R49L-1","SWISSMODEL-ERBINMUT-R49L.res");
            domainNameToFileNameMap.put("R49M-1","SWISSMODEL-ERBINMUT-R49M.res");
            domainNameToFileNameMap.put("R49N-1","SWISSMODEL-ERBINMUT-R49N.res");
            domainNameToFileNameMap.put("R49Q-1","SWISSMODEL-ERBINMUT-R49Q.res");
            domainNameToFileNameMap.put("R49S-1","SWISSMODEL-ERBINMUT-R49S.res");
            domainNameToFileNameMap.put("R49T-1","SWISSMODEL-ERBINMUT-R49T.res");
            domainNameToFileNameMap.put("R49V-1","SWISSMODEL-ERBINMUT-R49V.res");
            domainNameToFileNameMap.put("R49W-1","SWISSMODEL-ERBINMUT-R49W.res");
            domainNameToFileNameMap.put("R49Y-1","SWISSMODEL-ERBINMUT-R49Y.res");
            domainNameToFileNameMap.put("S26I-1","SWISSMODEL-ERBINMUT-S26I.res");
            domainNameToFileNameMap.put("S26K-1","SWISSMODEL-ERBINMUT-S26K.res");
            domainNameToFileNameMap.put("S26M-1","SWISSMODEL-ERBINMUT-S26M.res");
            domainNameToFileNameMap.put("S26N-1","SWISSMODEL-ERBINMUT-S26N.res");
            domainNameToFileNameMap.put("S26R-1","SWISSMODEL-ERBINMUT-S26R.res");
            domainNameToFileNameMap.put("S26T-1","SWISSMODEL-ERBINMUT-S26T.res");
            domainNameToFileNameMap.put("S28A-1","SWISSMODEL-ERBINMUT-S28A.res");
            domainNameToFileNameMap.put("S28D-1","SWISSMODEL-ERBINMUT-S28D.res");
            domainNameToFileNameMap.put("S28E-1","SWISSMODEL-ERBINMUT-S28E.res");
            domainNameToFileNameMap.put("S28G-1","SWISSMODEL-ERBINMUT-S28G.res");
            domainNameToFileNameMap.put("S28I-1","SWISSMODEL-ERBINMUT-S28I.res");
            domainNameToFileNameMap.put("S28K-1","SWISSMODEL-ERBINMUT-S28K.res");
            domainNameToFileNameMap.put("S28M-1","SWISSMODEL-ERBINMUT-S28M.res");
            domainNameToFileNameMap.put("S28N-1","SWISSMODEL-ERBINMUT-S28N.res");
            domainNameToFileNameMap.put("S28R-1","SWISSMODEL-ERBINMUT-S28R.res");
            domainNameToFileNameMap.put("S28T-1","SWISSMODEL-ERBINMUT-S28T.res");
            domainNameToFileNameMap.put("S28V-1","SWISSMODEL-ERBINMUT-S28V.res");
            domainNameToFileNameMap.put("T48A-1","SWISSMODEL-ERBINMUT-T48A.res");
            domainNameToFileNameMap.put("T48D-1","SWISSMODEL-ERBINMUT-T48D.res");
            domainNameToFileNameMap.put("T48E-1","SWISSMODEL-ERBINMUT-T48E.res");
            domainNameToFileNameMap.put("T48G-1","SWISSMODEL-ERBINMUT-T48G.res");
            domainNameToFileNameMap.put("T48K-1","SWISSMODEL-ERBINMUT-T48K.res");
            domainNameToFileNameMap.put("T48N-1","SWISSMODEL-ERBINMUT-T48N.res");
            domainNameToFileNameMap.put("T48R-1","SWISSMODEL-ERBINMUT-T48R.res");
            domainNameToFileNameMap.put("T48S-1","SWISSMODEL-ERBINMUT-T48S.res");
            domainNameToFileNameMap.put("V83A-1","SWISSMODEL-ERBINMUT-V83A.res");
            domainNameToFileNameMap.put("V83E-1","SWISSMODEL-ERBINMUT-V83E.res");
            domainNameToFileNameMap.put("V83I-1","SWISSMODEL-ERBINMUT-V83I.res");
            domainNameToFileNameMap.put("V83K-1","SWISSMODEL-ERBINMUT-V83K.res");
            domainNameToFileNameMap.put("V83L-1","SWISSMODEL-ERBINMUT-V83L.res");
            domainNameToFileNameMap.put("V83Q-1","SWISSMODEL-ERBINMUT-V83Q.res");
            domainNameToFileNameMap.put("V83T-1","SWISSMODEL-ERBINMUT-V83T.res");
            */
        }
        else if (organism.equals(Constants.MOUSE)||
               organism.equals(Constants.MOUSE_ORPHAN))
        {
            //domainNameToFileNameMap.put("GRIP2-5","SWISSMODEL-GRIP2-5.res");
            //domainNameToFileNameMap.put("GM1582-2","SWISSMODEL-GM1582-2.res");
            domainNameToFileNameMap.put("DVL1-1","1MC7.res");
            domainNameToFileNameMap.put("PTP-BL-2","1VJ6.res");
            domainNameToFileNameMap.put("PDZ-RGS3-1","1WHD.res");
            domainNameToFileNameMap.put("A1-SYNTROPHIN-1","1Z86.res");
            domainNameToFileNameMap.put("PDZK1-1","2EDZ.res");
            domainNameToFileNameMap.put("B1-SYNTROPHIN-1","SWISSMODEL-B1-SYNTROPHIN-1.res");
            domainNameToFileNameMap.put("CHAPSYN-110-2","SWISSMODEL-CHAPSYN-110-2.res");
            domainNameToFileNameMap.put("CHAPSYN-110-3","SWISSMODEL-CHAPSYN-110-3.res");
            domainNameToFileNameMap.put("CIPP-10","SWISSMODEL-CIPP-10.res");
            domainNameToFileNameMap.put("CIPP-3","SWISSMODEL-CIPP-3.res");
            domainNameToFileNameMap.put("CIPP-5","SWISSMODEL-CIPP-5.res");
            domainNameToFileNameMap.put("CIPP-8","SWISSMODEL-CIPP-8.res");
            domainNameToFileNameMap.put("CIPP-9","SWISSMODEL-CIPP-9.res");
            domainNameToFileNameMap.put("DVL3-1","SWISSMODEL-DVL3-1.res");
            domainNameToFileNameMap.put("ERBIN-1","SWISSMODEL-ERBIN-1.res");
            domainNameToFileNameMap.put("GRIP1-6","SWISSMODEL-GRIP1-6.res");
            domainNameToFileNameMap.put("HARMONIN-2","SWISSMODEL-HARMONIN-2.res");
            domainNameToFileNameMap.put("LARG-1","SWISSMODEL-LARG-1.res");
            domainNameToFileNameMap.put("LIN-7C-1","SWISSMODEL-LIN-7C-1.res");
            ///domainNameToFileNameMap.put("LNX1-2","SWISSMODEL-LNX1-2.res");
            domainNameToFileNameMap.put("LRRC7-1","SWISSMODEL-LRRC7-1.res");
            domainNameToFileNameMap.put("MAGI-1-6","SWISSMODEL-MAGI-1-6.res");
            domainNameToFileNameMap.put("MAGI-2-2","SWISSMODEL-MAGI-2-2.res");
            domainNameToFileNameMap.put("MAGI-2-5","SWISSMODEL-MAGI-2-5.res");
            domainNameToFileNameMap.put("MAGI-2-6","SWISSMODEL-MAGI-2-6.res");
            domainNameToFileNameMap.put("MAGI-3-1","SWISSMODEL-MAGI-3-1.res");
            domainNameToFileNameMap.put("MAGI-3-2","SWISSMODEL-MAGI-3-2.res");
            domainNameToFileNameMap.put("MAGI-3-5","SWISSMODEL-MAGI-3-5.res");
            domainNameToFileNameMap.put("MALS2-1","SWISSMODEL-MALS2-1.res");
            domainNameToFileNameMap.put("MPP7-1","SWISSMODEL-MPP7-1.res");
            domainNameToFileNameMap.put("MUPP1-1","SWISSMODEL-MUPP1-1.res");
            domainNameToFileNameMap.put("MUPP1-10","SWISSMODEL-MUPP1-10.res");
            domainNameToFileNameMap.put("MUPP1-11","SWISSMODEL-MUPP1-11.res");
            domainNameToFileNameMap.put("MUPP1-12","SWISSMODEL-MUPP1-12.res");
            domainNameToFileNameMap.put("MUPP1-13","SWISSMODEL-MUPP1-13.res");
            domainNameToFileNameMap.put("MUPP1-5","SWISSMODEL-MUPP1-5.res");
            domainNameToFileNameMap.put("NHERF-1-1","SWISSMODEL-NHERF-1-1.res");
            domainNameToFileNameMap.put("NHERF-2-2","SWISSMODEL-NHERF-2-2.res");
            domainNameToFileNameMap.put("NNOS-1","SWISSMODEL-NNOS-1.res");
            domainNameToFileNameMap.put("OMP25-1","SWISSMODEL-OMP25-1.res");
            domainNameToFileNameMap.put("PAR6B-1","SWISSMODEL-PAR6B-1.res");
            domainNameToFileNameMap.put("PDZK1-3","SWISSMODEL-PDZK1-3.res");
            domainNameToFileNameMap.put("PDZK11-1","SWISSMODEL-PDZK11-1.res");
            domainNameToFileNameMap.put("PSD95-1","SWISSMODEL-PSD95-1.res");
            domainNameToFileNameMap.put("PSD95-2","SWISSMODEL-PSD95-2.res");
            domainNameToFileNameMap.put("PSD95-3","SWISSMODEL-PSD95-3.res");
            domainNameToFileNameMap.put("SAP102-2","SWISSMODEL-SAP102-2.res");
            domainNameToFileNameMap.put("SAP102-3","SWISSMODEL-SAP102-3.res");
            domainNameToFileNameMap.put("SAP97-1","SWISSMODEL-SAP97-1.res");
            domainNameToFileNameMap.put("SAP97-2","SWISSMODEL-SAP97-2.res");
            domainNameToFileNameMap.put("SAP97-3","SWISSMODEL-SAP97-3.res");
            domainNameToFileNameMap.put("SCRB1-1","SWISSMODEL-SCRB1-1.res");
            domainNameToFileNameMap.put("SCRB1-2","SWISSMODEL-SCRB1-2.res");
          domainNameToFileNameMap.put("SCRB1-3","SWISSMODEL-SCRB1-3.res");
            domainNameToFileNameMap.put("SEMCAP3-1","SWISSMODEL-SEMCAP3-1.res");
            domainNameToFileNameMap.put("SHANK1-1","SWISSMODEL-SHANK1-1.res");
            domainNameToFileNameMap.put("SHANK3-1","SWISSMODEL-SHANK3-1.res");
          domainNameToFileNameMap.put("SHROOM-1","SWISSMODEL-SHROOM-1.res");
            domainNameToFileNameMap.put("SLIM-1","SWISSMODEL-SLIM-1.res");
            //domainNameToFileNameMap.put("TIP-1-1","SWISSMODEL-TIP-1-1.res");
            domainNameToFileNameMap.put("ZO-1-1","SWISSMODEL-ZO-1-1.res");
            domainNameToFileNameMap.put("ZO-2-1","SWISSMODEL-ZO-2-1.res");
          domainNameToFileNameMap.put("ZO-3-1","SWISSMODEL-ZO-3-1.res");

        //}
        //else if (type.equals(Constants.CHEN_MOUSE_ORPHAN_PDB))
        //{
            //CHEN_MOUSE_ORPHAN_PDB
            domainNameToFileNameMap.put("GOPC1-1", "SWISSMODEL-GOPC1-1.res");
            domainNameToFileNameMap.put("MAGI-2-3", "SWISSMODEL-MAGI-2-3.res");
            domainNameToFileNameMap.put("MAGI-2-4", "SWISSMODEL-MAGI-2-4.res");
            domainNameToFileNameMap.put("MUPP1-2", "SWISSMODEL-MUPP1-2.res");
            domainNameToFileNameMap.put("NHERF1-2", "SWISSMODEL-NHERF-1-2.res");
            domainNameToFileNameMap.put("PDZK1-4", "SWISSMODEL-PDZK1-4.res");
            domainNameToFileNameMap.put("SCRB-1-4", "SWISSMODEL-SCRB1-4.res");
            domainNameToFileNameMap.put("IL-16-3", "SWISSMODEL-IL-16-3.res");
            domainNameToFileNameMap.put("GRIP-1-4", "SWISSMODEL-GRIP1-4.res");
            domainNameToFileNameMap.put("GRIP-1-5", "SWISSMODEL-GRIP1-5.res");
            domainNameToFileNameMap.put("PAR-6G-1", "SWISSMODEL-PAR6G-1.res");
            domainNameToFileNameMap.put("CIPP-7", "SWISSMODEL-CIPP-7.res");
            domainNameToFileNameMap.put("MUPP1-6", "SWISSMODEL-MUPP1-6.res");
            domainNameToFileNameMap.put("DELPHILIN-1", "SWISSMODEL-DELPHILIN-1.res");
            domainNameToFileNameMap.put("PAR-3B-3", "SWISSMODEL-PAR-3B-3.res");
            domainNameToFileNameMap.put("RGS-12-1", "SWISSMODEL-RGS-12-1.res");
            domainNameToFileNameMap.put("MAGI-1-1", "SWISSMODEL-MAGI-1-1.res");
            domainNameToFileNameMap.put("A330043P19-1", "SWISSMODEL-A330043P19-1.res");
            domainNameToFileNameMap.put("PDZK-7-1", "SWISSMODEL-PDZK-7-1.res");
            domainNameToFileNameMap.put("DLG-5-2", "SWISSMODEL-DLG-5-2.res");
            
            // TAP PSD95
            domainNameToFileNameMap.put("CHAPSYN-110-1", "SWISSMODEL-CHAPSYN-110-1.res");
            domainNameToFileNameMap.put("SAP102-1", "SWISSMODEL-SAP102-1.res");
            domainNameToFileNameMap.put("SHANK2-1", "SWISSMODEL-SHANK2-1.res");
            domainNameToFileNameMap.put("MAGI-3-4", "SWISSMODEL-MAGI-3-4.res");
            domainNameToFileNameMap.put("MAGI-3-5_", "SWISSMODEL-MAGI-3-5_.res");
            domainNameToFileNameMap.put("FRPD4-1", "SWISSMODEL-FRPD4-1.res");
            domainNameToFileNameMap.put("CNKR2-1", "SWISSMODEL-CNKR2-1.res");
        }
        else if (organism.equals(Constants.FLY))
        {
            // CHEN FLY PDB
            domainNameToFileNameMap.put("DLG-1-1", "SWISSMODEL-DLG-1-1.res");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.res");
            domainNameToFileNameMap.put("MAGI-4", "SWISSMODEL-MAGI-4.res");
            domainNameToFileNameMap.put("PATJ-2", "SWISSMODEL-PATJ-2.res");
            domainNameToFileNameMap.put("PAR6-1", "1RY4.res");
            domainNameToFileNameMap.put("LAP4-2", "SWISSMODEL-LAP4-2.res");
            domainNameToFileNameMap.put("LAP4-3", "SWISSMODEL-LAP4-3.res");

        }
        else if (organism.equals(Constants.WORM))
        {
            // CHEN WORM PDB
            domainNameToFileNameMap.put("DLG1-1", "SWISSMODEL-DLG1-1.res");
            domainNameToFileNameMap.put("DLG1-3", "SWISSMODEL-DLG1-3.res");
            domainNameToFileNameMap.put("DSH-1", "SWISSMODEL-DSH-1.res");
            domainNameToFileNameMap.put("LIN7-1", "SWISSMODEL-LIN7-1.res");
            domainNameToFileNameMap.put("STN2-1", "SWISSMODEL-STN2-1.res");
            domainNameToFileNameMap.put("MPZ1-6", "SWISSMODEL-MPZ1-6.res");
            domainNameToFileNameMap.put("NAB1-1", "SWISSMODEL-NAB1-1.res");

            // SIDHU WORM PDB
            domainNameToFileNameMap.put("F25H2.2-1", "SWISSMODEL-F25H2.2-1.res");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1.res");
            domainNameToFileNameMap.put("C43E11.6a-1", "SWISSMODEL-C43E11.6a-1.res");
            //domainNameToFileNameMap.put("C09H6.2a-2", "SWISSMODEL-C09H6.2a-2.res");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1.res");
            domainNameToFileNameMap.put("C10C6.1-1", "SWISSMODEL-C10C6.1-1.res");
            domainNameToFileNameMap.put("H09G03.2a-1", "SWISSMODEL-H09G03.2a-1.res");
            //domainNameToFileNameMap.put("T21G5.4-1", "SWISSMODEL-T21G5.4-1");
            domainNameToFileNameMap.put("W03F11.6a-1", "SWISSMODEL-W03F11.6a-1.res");
            domainNameToFileNameMap.put("K01A6.2-4", "SWISSMODEL-K01A6.2-4.res");
            //domainNameToFileNameMap.put("T10A3.1a-1", "SWISSMODEL-T10A3.1a-1");
            domainNameToFileNameMap.put("Y38C1AB.8-2", "SWISSMODEL-Y38C1AB.8-2.res");


        }
    }
    public Features encodeFeatures(String domainName)
    {
        featureValues = new ArrayList();
        String filename = (String)domainNameToFileNameMap.get(domainName);
        filename = surfvDir+filename ;
        List residueNumList = bindingSite.getResidueNumList(domainName);

        try
        {
            BufferedReader br = new BufferedReader(new FileReader(new File(filename)));
            String line = "" ;
            br.readLine();
            while((line=br.readLine())!=null)
            {
                line = line.trim();

                if (line.startsWith("total"))
                    break;

                String[] splitTokens = line.split("\\s+");
                int resNum = 0;
                try
                {
                    resNum = Integer.parseInt(splitTokens[2]);

                }
                catch(NumberFormatException e)
                {
                   resNum = Integer.parseInt(splitTokens[1]);
                }
                //if (line.startsWith("x"))
                if (residueNumList.contains(resNum))
                {
                    int len = splitTokens.length;
                    double sasa = Double.parseDouble(splitTokens[len-1]);

                    featureValues.add(sasa);

                }
            }
            br.close();


        }
        catch (Exception e)
        {
            //System.out.println("Exception: " + e);
            //e.printStackTrace();
            //System.out.println(domainName);

        }
        Features f = new Features();
        f.addFeatureValues(featureValues);
        return f;
    }
    public List encodeFeature(String domainName)
    {
        return new ArrayList();
    }
    public static void main(String[] args)
    {
        String organism = args[1];
        SurfvFeatureEncoding surfv = new SurfvFeatureEncoding(organism);
        //SurfvFeatureEncoding surfv = new SurfvFeatureEncoding(Constants.MOUSE);
        //SurfvFeatureEncoding surfv = new SurfvFeatureEncoding(Constants.FLY);
        //SurfvFeatureEncoding surfv = new SurfvFeatureEncoding(Constants.WORM);

        /*DataLoader dl = new DataLoader();
        //dl.loadMousePDBTest(Constants.CHEN_MOUSE_ORPHAN_PDB);
        dl.loadMouseTest(Constants.MOUSE_ORPHAN);

        List posTrainProfileList = dl.getPosTestProfileList();
        List negTrainProfileList = dl.getNegTestProfileList();
        List seenList = new ArrayList();
        for (int i=0;i < posTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)posTrainProfileList.get(i);
            seenList.add(profile.getName());
            String domainName = profile.getName();//args[0];
            System.out.println(domainName);

            Features ft = surfv.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        for (int i=0;i < negTrainProfileList.size();i++)
        {
            ProteinProfile profile = (ProteinProfile)negTrainProfileList.get(i);
            String domainName = profile.getName();//args[0];
            if (seenList.contains(domainName))
                continue;
            System.out.println(domainName);

            Features ft = surfv.encodeFeatures(domainName);
            System.out.println(domainName +"\t" + ft.numFeatures());
            System.out.println(ft.getFeatureValues());
        }
        */
        /*String domainName = args[0];
        Features ft = surfv.encodeFeatures(domainName);
        System.out.println(domainName +"\t" + ft.numFeatures());
        System.out.println(ft.getFeatureValues());
        */
        List domainNameList = new ArrayList();
        domainNameList.add("GRD2I-1");
        //domainNameList.add("MAGI1-1");
        domainNameList.add("MAGI2-3");
        domainNameList.add("MAGI3-3");
        //domainNameList.add("MAGI3-1");
        domainNameList.add("PDZD2-4");
        domainNameList.add("SDCBP-1");

        for(int i=0; i < domainNameList.size();i++)
        {
            String domainName = (String)domainNameList.get(i);
        Features ft = surfv.encodeFeatures(domainName);
        System.out.println(domainName +"\t" + ft.numFeatures());
        System.out.println(ft.getFeatureValues());
        }
    }
}