package org.baderlab.pdzsvmstruct.encoding;

import java.util.List;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Abstract class for feature encodings
 */
public abstract class FeatureEncoding
{
    protected List featureValues = null;
    private String name = "";
    protected abstract List encodeFeature(String value);

    // raw features is a string of comma delimited chars
    public Features encodeFeatures(String rawFeatures)
    {
        // List of chars - only support raw features as amino acid features
        Features f = new Features();
        for (int i =0;i < rawFeatures.length();i++)
        {
            String ch = String.valueOf(rawFeatures.charAt(i));
            if (ch.equals("-"))
                System.out.println("\tInvalid char: " + rawFeatures);    

            this.featureValues = encodeFeature(ch);
           
            f.addFeatureValues(featureValues);
        }
        //System.out.println("Num encoded features: " + f.numFeatures());
        return f;
    }

    public String getEncodingName()
    {
        return name;
    }

    public void setEncodingName(String name)
    {
        this.name = name;
    }

    public List getFeatureValuesList()
    {
        return featureValues;
    }

    public String getFeatures(String domainSeq, String organism)
    {
        return "";
    }
}
