package org.baderlab.pdzsvmstruct.optimize;

import weka.core.Utils;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Represents a grid result from grid search
 */
public class GridResult
{
    public double rocAUC = 0.0;
    public double prAUC = 0.0;

    public double spec = 0.0;
    public double sens = 0.0;
    public double tPrec = 0.0;
    public double fPrec = 0.0;
    public double tFMeasure = 0.0;
    public double fFMeasure = 0.0;
    public double fMeasure = 0.0;
    public double mcc = 0.0;
    public double g = 0.0;
    public double g2 = 0.0;

    public double C = 0.0;
    public double degree = 0;
    public double coef0 =0.0;
    private int hashCode = 0;
    public double accuracy = 0.0;


    public GridResult()
    {
        this.hashCode = this.hashCode();

    }
    public int getHashCode()
    {
        return hashCode;
    }

    public static String headerString()
    {
        String header = " g     C     rAUC    prAUC   Sens    Spec    tPrec   fPrec   tMeas   fMeas   MCC     FMeas   Accuracy";
        return header;
    }
    public String toString()
    {

        StringBuffer text = new StringBuffer();
        String d = Utils.padRight(new String(Utils.doubleToString(g,5,2) + "," + Utils.doubleToString(C,5,2)),11);
        text.append(d);
        text.append(Utils.doubleToString(rocAUC, 7, 3)).append(" ");
        text.append(Utils.doubleToString(prAUC, 7, 3)).append(" ");

        text.append(Utils.doubleToString(sens, 7, 3)).append(" ");
        text.append(Utils.doubleToString(spec, 7, 3)).append(" ");
        text.append(Utils.doubleToString(tPrec, 7, 3)).append(" ");
        text.append(Utils.doubleToString(fPrec, 7, 3)).append(" ");
        text.append(Utils.doubleToString(tFMeasure, 7, 3)).append(" ");
        text.append(Utils.doubleToString(fFMeasure, 7, 3)).append(" ");
        text.append(Utils.doubleToString(mcc, 7, 3)).append(" ");
        text.append(Utils.doubleToString(fMeasure, 7, 3));
        text.append(Utils.doubleToString(accuracy, 7, 3));

        return text.toString();
    }
}
