package org.baderlab.pdzsvmstruct.encoding;

import java.util.List;
import java.util.ArrayList;
import java.text.DecimalFormat;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class PeptideFeatureEncoding extends FeatureEncoding{
    //private AminoAcidIndexFeatureEncoding aa;
    private BinarySequenceFeatureEncoding aa;
    public PeptideFeatureEncoding()
    {
        setEncodingName("PEPTIDE");
        aa = new BinarySequenceFeatureEncoding();
    }
    public List encodeFeature(String site)
    {
        return new ArrayList();
    }
    public Features encodeFeatures(String sequence)
    {
        //System.out.println(sequence);
        Features aaFeatures = aa.encodeFeatures(sequence);
        List aaFeaturesList = aaFeatures.getFeatureValues();

        featureValues = new ArrayList();
        featureValues.addAll(aaFeaturesList);

        Features f = new Features();
        f.addFeatureValues(featureValues);
        return f;
    }
    public static void main(String[] arg)
    {
        PeptideFeatureEncoding p = new PeptideFeatureEncoding();
        Features ft = p.encodeFeatures("KETLV");
        List values = ft.getFeatureValues();
        DecimalFormat d = new DecimalFormat("#");
        for (int i=0; i < values.size();i++)
        {
            System.out.print(d.format(values.get(i))+" ");
        }

    }
}
